/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.semanticweb.elk.RandomSeedProvider;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.Owl2StreamLoader;
import org.semanticweb.elk.owl.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.managers.ElkEntityRecycler;
import org.semanticweb.elk.owl.managers.ElkObjectRecycler;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2ParserFactory;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.reasoner.ClassTaxonomyTestOutput;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasoningTestManifest;
import org.semanticweb.elk.reasoner.TestReasonerUtils;
import org.semanticweb.elk.reasoner.incremental.OnOffVector;
import org.semanticweb.elk.reasoner.incremental.RandomWalkIncrementalClassificationRunner;
import org.semanticweb.elk.reasoner.stages.PostProcessingStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.testing.PolySuite;
import org.semanticweb.elk.testing.TestInput;
import org.semanticweb.elk.testing.io.URLTestIO;

@RunWith(value=PolySuite.class)
public abstract class BaseRandomWalkIncrementalCorrectnessTest {
    protected static final Logger LOGGER_ = Logger.getLogger(BaseRandomWalkIncrementalCorrectnessTest.class);
    static int MAX_ROUNDS = 5;
    static int ITERATIONS = 5;
    protected final ReasoningTestManifest<? extends ClassTaxonomyTestOutput, ? extends ClassTaxonomyTestOutput> manifest;

    public BaseRandomWalkIncrementalCorrectnessTest(ReasoningTestManifest<? extends ClassTaxonomyTestOutput, ? extends ClassTaxonomyTestOutput> testManifest) {
        this.manifest = testManifest;
    }

    @Before
    public void before() throws IOException, Owl2ParseException {
        Assume.assumeTrue((!this.ignore(this.manifest.getInput()) ? 1 : 0) != 0);
    }

    protected boolean ignore(TestInput input) {
        return false;
    }

    @Test
    public void randomWalk() throws Exception {
        OnOffVector<ElkAxiom> changingAxioms = new OnOffVector<ElkAxiom>(128);
        ArrayList<ElkAxiom> staticAxioms = new ArrayList<ElkAxiom>();
        long seed = RandomSeedProvider.VALUE;
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)"Initial load of test axioms");
        }
        InputStream stream = ((URLTestIO)this.manifest.getInput()).getInputStream();
        Owl2StreamLoader fileLoader = new Owl2StreamLoader((Owl2ParserFactory)new Owl2FunctionalStyleParserFactory((ElkObjectFactory)new ElkObjectFactoryImpl((ElkObjectRecycler)new ElkEntityRecycler())), stream);
        AxiomLoader trackingLoader = this.getAxiomTrackingLoader((AxiomLoader)fileLoader, changingAxioms, staticAxioms);
        Reasoner incrementalReasoner = TestReasonerUtils.createTestReasoner(trackingLoader, (ReasonerStageExecutor)new PostProcessingStageExecutor());
        incrementalReasoner.setAllowIncrementalMode(true);
        try {
            this.getRandomWalkRunner(MAX_ROUNDS, ITERATIONS).run(incrementalReasoner, changingAxioms, staticAxioms, seed);
        }
        catch (Exception e) {
            throw new ElkRuntimeException("Seed " + seed, (Throwable)e);
        }
        finally {
            incrementalReasoner.shutdown();
        }
    }

    protected abstract AxiomLoader getAxiomTrackingLoader(AxiomLoader var1, OnOffVector<ElkAxiom> var2, List<ElkAxiom> var3);

    protected abstract RandomWalkIncrementalClassificationRunner<ElkAxiom> getRandomWalkRunner(int var1, int var2);
}

