/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.semanticweb.elk.RandomSeedProvider;
import org.semanticweb.elk.io.IOUtils;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasoningTestManifest;
import org.semanticweb.elk.reasoner.incremental.IncrementalChangeType;
import org.semanticweb.elk.reasoner.incremental.OnOffVector;
import org.semanticweb.elk.testing.PolySuite;
import org.semanticweb.elk.testing.TestInput;
import org.semanticweb.elk.testing.TestOutput;
import org.semanticweb.elk.testing.io.URLTestIO;
import org.semanticweb.elk.util.collections.Operations;

@RunWith(value=PolySuite.class)
public abstract class BaseIncrementalReasoningCorrectnessTest<T, EO extends TestOutput, AO extends TestOutput> {
    protected static final Logger LOGGER_ = Logger.getLogger(BaseIncrementalReasoningCorrectnessTest.class);
    static final int REPEAT_NUMBER = 5;
    static final double DELETE_RATIO = 0.2;
    protected final ReasoningTestManifest<EO, AO> manifest;
    protected List<T> staticAxioms = null;
    protected OnOffVector<T> changingAxioms = null;

    public BaseIncrementalReasoningCorrectnessTest(ReasoningTestManifest<EO, AO> testManifest) {
        this.manifest = testManifest;
    }

    @Before
    public void before() throws IOException, Owl2ParseException {
        Assume.assumeTrue((!this.ignore(this.manifest.getInput()) ? 1 : 0) != 0);
        InputStream stream = null;
        try {
            stream = ((URLTestIO)this.manifest.getInput()).getInputStream();
            this.staticAxioms = new ArrayList<T>(15);
            this.changingAxioms = new OnOffVector(15);
            this.loadAxioms(stream, this.staticAxioms, this.changingAxioms);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    protected boolean ignore(TestInput input) {
        return false;
    }

    @Test
    public void incrementalReasoning() throws ElkException {
        this.changingAxioms.setAllOn();
        Reasoner standardReasoner = this.getReasoner(Operations.concat(this.staticAxioms, this.changingAxioms.getOnElements()));
        Reasoner incrementalReasoner = this.getReasoner(Operations.concat(this.staticAxioms, this.changingAxioms.getOnElements()));
        standardReasoner.setAllowIncrementalMode(false);
        incrementalReasoner.setAllowIncrementalMode(true);
        this.correctnessCheck(standardReasoner, incrementalReasoner, -1L);
        long seed = RandomSeedProvider.VALUE;
        Random rnd = new Random(seed);
        for (int i = 0; i < 5; ++i) {
            this.changingAxioms.setAllOff();
            this.randomFlip(this.changingAxioms, rnd, 0.2);
            if (LOGGER_.isDebugEnabled()) {
                for (T del : this.changingAxioms.getOnElements()) {
                    this.dumpChangeToLog(del, Level.DEBUG);
                }
            }
            this.applyChanges(standardReasoner, this.changingAxioms.getOnElements(), IncrementalChangeType.DELETE);
            this.applyChanges(incrementalReasoner, this.changingAxioms.getOnElements(), IncrementalChangeType.DELETE);
            if (LOGGER_.isInfoEnabled()) {
                LOGGER_.info((Object)"===DELETIONS===");
            }
            this.correctnessCheck(standardReasoner, incrementalReasoner, seed);
            this.applyChanges(standardReasoner, this.changingAxioms.getOnElements(), IncrementalChangeType.ADD);
            this.applyChanges(incrementalReasoner, this.changingAxioms.getOnElements(), IncrementalChangeType.ADD);
            if (LOGGER_.isInfoEnabled()) {
                LOGGER_.info((Object)"===ADDITIONS===");
            }
            this.correctnessCheck(standardReasoner, incrementalReasoner, seed);
        }
    }

    protected void randomFlip(OnOffVector<T> axioms, Random rnd, double fraction) {
        Collections.shuffle(axioms, rnd);
        int flipped = 0;
        for (int i = 0; i < axioms.size() && (double)flipped <= fraction * (double)axioms.size(); ++i) {
            axioms.flipOnOff(i);
            ++flipped;
        }
    }

    protected abstract void applyChanges(Reasoner var1, Iterable<T> var2, IncrementalChangeType var3);

    protected abstract void dumpChangeToLog(T var1, Level var2);

    protected abstract void loadAxioms(InputStream var1, List<T> var2, OnOffVector<T> var3) throws IOException, Owl2ParseException;

    protected abstract Reasoner getReasoner(Iterable<T> var1);

    protected abstract void correctnessCheck(Reasoner var1, Reasoner var2, long var3) throws ElkException;
}

