/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.ClassTaxonomyTestOutput;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasoningTestManifest;
import org.semanticweb.elk.reasoner.TaxonomyDiffManifest;
import org.semanticweb.elk.reasoner.incremental.BaseIncrementalReasoningCorrectnessTest;
import org.semanticweb.elk.reasoner.incremental.IncrementalClassificationCorrectnessTest;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyPrinter;
import org.semanticweb.elk.reasoner.taxonomy.hashing.TaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.testing.ConfigurationUtils;
import org.semanticweb.elk.testing.PolySuite;
import org.semanticweb.elk.testing.TestManifest;
import org.semanticweb.elk.testing.io.URLTestIO;

@RunWith(value=PolySuite.class)
public abstract class BaseIncrementalRealizationCorrectnessTest<T>
extends BaseIncrementalReasoningCorrectnessTest<T, ClassTaxonomyTestOutput, ClassTaxonomyTestOutput> {
    static final String INPUT_DATA_LOCATION = "realization_test_input";

    public BaseIncrementalRealizationCorrectnessTest(ReasoningTestManifest<ClassTaxonomyTestOutput, ClassTaxonomyTestOutput> testManifest) {
        super(testManifest);
    }

    @Override
    protected void correctnessCheck(Reasoner standardReasoner, Reasoner incrementalReasoner, long seed) throws ElkException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)"======= Computing Expected Instance Taxonomy =======");
        }
        InstanceTaxonomy expected = standardReasoner.getInstanceTaxonomyQuietly();
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)"======= Computing Incremental Instance Taxonomy =======");
        }
        InstanceTaxonomy incremental = incrementalReasoner.getInstanceTaxonomyQuietly();
        if (TaxonomyHasher.hash((Taxonomy)expected) != TaxonomyHasher.hash((Taxonomy)incremental)) {
            StringWriter writer = new StringWriter();
            try {
                writer.write("EXPECTED TAXONOMY:\n");
                TaxonomyPrinter.dumpInstanceTaxomomy((InstanceTaxonomy)expected, (Writer)writer, (boolean)false);
                writer.write("\nINCREMENTAL TAXONOMY:\n");
                TaxonomyPrinter.dumpInstanceTaxomomy((InstanceTaxonomy)incremental, (Writer)writer, (boolean)false);
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Assert.fail((String)("Seed: " + seed + "\n" + writer.getBuffer().toString()));
        }
    }

    @PolySuite.Config
    public static PolySuite.Configuration getConfig() throws URISyntaxException, IOException {
        return ConfigurationUtils.loadFileBasedTestConfiguration((String)INPUT_DATA_LOCATION, IncrementalClassificationCorrectnessTest.class, (String)"owl", (String)"expected", (ConfigurationUtils.TestManifestCreator)new ConfigurationUtils.TestManifestCreator<URLTestIO, ClassTaxonomyTestOutput, ClassTaxonomyTestOutput>(){

            public TestManifest<URLTestIO, ClassTaxonomyTestOutput, ClassTaxonomyTestOutput> create(URL input, URL output) throws IOException {
                return new TaxonomyDiffManifest(input, null);
            }
        });
    }
}

