/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.config;

import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.config.ConfigurationException;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.config.UnsupportedFeatureTreatment;

public class ReasoningConfigurationTest {
    @Test
    public void defaultConfig() {
        ReasonerConfiguration config = ReasonerConfiguration.getConfiguration();
        Assert.assertTrue((boolean)config.getParameterNames().contains("elk.reasoner.number_of_workers"));
        Assert.assertTrue((boolean)config.getParameterNames().contains("elk.reasoner.unsupported_feature_treatment"));
        Assert.assertEquals((long)Runtime.getRuntime().availableProcessors(), (long)config.getParameterAsInt("elk.reasoner.number_of_workers"));
        Assert.assertEquals((Object)UnsupportedFeatureTreatment.IGNORE.toString(), (Object)config.getParameter("elk.reasoner.unsupported_feature_treatment"));
    }

    @Test(expected=ConfigurationException.class)
    public void wrongIntParameterValue() {
        ReasonerConfiguration config = ReasonerConfiguration.getConfiguration();
        config.setParameter("elk.reasoner.unsupported_feature_treatment", "something unsupported here");
    }

    @Test(expected=ConfigurationException.class)
    public void wrongEnumParameterValue() {
        ReasonerConfiguration config = ReasonerConfiguration.getConfiguration();
        config.setParameter("elk.reasoner.number_of_workers", "not an integer");
    }
}

