/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.config.ConfigurationException;
import org.semanticweb.elk.config.ConfigurationFactory;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.EmptyAxiomLoader;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasonerFactory;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.stages.FailingOnInterruptStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;

public class ReasonerFactoryTest {
    @Test
    public void createReasonerDefaultConfig() {
        Reasoner reasoner = new ReasonerFactory().createReasoner((AxiomLoader)new EmptyAxiomLoader(), (ReasonerStageExecutor)new FailingOnInterruptStageExecutor());
        Assert.assertEquals((long)Runtime.getRuntime().availableProcessors(), (long)reasoner.getNumberOfWorkers());
    }

    @Test
    public void createReasonerCustomConfig() throws ConfigurationException, IOException {
        Reasoner reasoner = new ReasonerFactory().createReasoner((AxiomLoader)new EmptyAxiomLoader(), (ReasonerStageExecutor)new FailingOnInterruptStageExecutor(), (ReasonerConfiguration)new ConfigurationFactory().getConfiguration(this.getClass().getClassLoader().getResourceAsStream("elk_test.properties"), "elk.reasoner", ReasonerConfiguration.class));
        Assert.assertNotNull((Object)reasoner);
        Assert.assertEquals((long)10L, (long)reasoner.getNumberOfWorkers());
        Assert.assertFalse((boolean)reasoner.isIncrementalMode());
    }
}

