/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.semanticweb.elk.io.IOUtils;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.managers.ElkEntityRecycler;
import org.semanticweb.elk.owl.managers.ElkObjectRecycler;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.reasoner.BaseRealizationCorrectnessTest;
import org.semanticweb.elk.reasoner.InstanceTaxonomyTestOutput;
import org.semanticweb.elk.reasoner.ReasoningTestManifest;
import org.semanticweb.elk.reasoner.TaxonomyDiffManifest;
import org.semanticweb.elk.reasoner.taxonomy.MockTaxonomyLoader;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.testing.ConfigurationUtils;
import org.semanticweb.elk.testing.PolySuite;
import org.semanticweb.elk.testing.TestManifest;
import org.semanticweb.elk.testing.io.URLTestIO;

public abstract class DiffRealizationCorrectnessTest
extends BaseRealizationCorrectnessTest<InstanceTaxonomyTestOutput> {
    public DiffRealizationCorrectnessTest(ReasoningTestManifest<InstanceTaxonomyTestOutput, InstanceTaxonomyTestOutput> testManifest) {
        super(testManifest);
    }

    @PolySuite.Config
    public static PolySuite.Configuration getConfig() throws URISyntaxException, IOException {
        return ConfigurationUtils.loadFileBasedTestConfiguration((String)"realization_test_input", DiffRealizationCorrectnessTest.class, (String)"owl", (String)"expected", (ConfigurationUtils.TestManifestCreator)new ConfigurationUtils.TestManifestCreator<URLTestIO, InstanceTaxonomyTestOutput, InstanceTaxonomyTestOutput>(){

            public TestManifest<URLTestIO, InstanceTaxonomyTestOutput, InstanceTaxonomyTestOutput> create(URL input, URL output) throws IOException {
                TaxonomyDiffManifest taxonomyDiffManifest;
                InputStream stream = null;
                try {
                    ElkObjectFactoryImpl objectFactory = new ElkObjectFactoryImpl((ElkObjectRecycler)new ElkEntityRecycler());
                    stream = output.openStream();
                    InstanceTaxonomy<ElkClass, ElkNamedIndividual> expectedTaxonomy = MockTaxonomyLoader.load((ElkObjectFactory)objectFactory, new Owl2FunctionalStyleParserFactory((ElkObjectFactory)objectFactory).getParser(stream));
                    taxonomyDiffManifest = new TaxonomyDiffManifest(input, new InstanceTaxonomyTestOutput(expectedTaxonomy));
                }
                catch (Owl2ParseException e) {
                    try {
                        throw new IOException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(stream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)stream);
                return taxonomyDiffManifest;
            }
        });
    }
}

