/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.EmptyAxiomLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.TestLoader;
import org.semanticweb.elk.reasoner.TestReasonerUtils;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.stages.SimpleStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;

public class ComplexClassQueryTest {
    final ElkObjectFactory objectFactory = new ElkObjectFactoryImpl();

    @Test
    public void testSimpleSubsumption() throws ElkException {
        TestLoader loader = new TestLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new SimpleStageExecutor());
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)A, (ElkClassExpression)B));
        Assert.assertFalse((boolean)reasoner.isSatisfiable((ElkClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)A, (ElkClassExpression)this.objectFactory.getObjectComplementOf((ElkClassExpression)B), new ElkClassExpression[0])));
        Assert.assertTrue((boolean)reasoner.isSatisfiable((ElkClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)B, (ElkClassExpression)this.objectFactory.getObjectComplementOf((ElkClassExpression)A), new ElkClassExpression[0])));
    }

    @Test
    public void testSatisfiabilityExistential() throws ElkException {
        TestLoader loader = new TestLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new SimpleStageExecutor());
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)A, (ElkClassExpression)PredefinedElkClass.OWL_NOTHING));
        reasoner.isInconsistent();
        ElkObjectProperty R = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":R"));
        Assert.assertFalse((boolean)reasoner.isSatisfiable((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)R, (ElkClassExpression)A)));
        Assert.assertTrue((boolean)reasoner.isSatisfiable((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)R, (ElkClassExpression)B)));
    }

    @Test
    public void testSatisfiabilityExistentialSubsumption() throws ElkException {
        TestLoader loader = new TestLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new SimpleStageExecutor());
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)A, (ElkClassExpression)B));
        reasoner.getTaxonomy();
        ElkObjectProperty R = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":R"));
        Assert.assertFalse((boolean)reasoner.isSatisfiable((ElkClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)R, (ElkClassExpression)A), (ElkClassExpression)this.objectFactory.getObjectComplementOf((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)R, (ElkClassExpression)B)), new ElkClassExpression[0])));
        Assert.assertTrue((boolean)reasoner.isSatisfiable((ElkClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)R, (ElkClassExpression)B), (ElkClassExpression)this.objectFactory.getObjectComplementOf((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)R, (ElkClassExpression)A)), new ElkClassExpression[0])));
    }

    @Test
    public void testSupSubClassConjunction() throws ElkException {
        TestLoader loader = new TestLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new SimpleStageExecutor());
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass C = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)A, (ElkClassExpression)B)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)B, (ElkClassExpression)C));
        reasoner.getTaxonomy();
        Set superClasses = reasoner.getSuperClasses((ElkClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)B, (ElkClassExpression)C, new ElkClassExpression[0]), true);
        Assert.assertEquals((long)1L, (long)superClasses.size());
        for (Node node : superClasses) {
            Assert.assertTrue((boolean)node.getMembers().contains(C));
        }
        Set subClasses = reasoner.getSubClasses((ElkClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)B, (ElkClassExpression)C, new ElkClassExpression[0]), true);
        Assert.assertEquals((long)1L, (long)subClasses.size());
        for (Node node : subClasses) {
            Assert.assertTrue((boolean)node.getMembers().contains(A));
        }
    }

    @Test
    public void testEquivalentClasses() throws ElkException {
        Reasoner reasoner = TestReasonerUtils.createTestReasoner((AxiomLoader)new EmptyAxiomLoader(), (ReasonerStageExecutor)new SimpleStageExecutor());
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkObjectIntersectionOf queryExpression = this.objectFactory.getObjectIntersectionOf((ElkClassExpression)A, (ElkClassExpression)B, new ElkClassExpression[0]);
        Assert.assertEquals((long)0L, (long)reasoner.getEquivalentClasses((ElkClassExpression)queryExpression).getMembers().size());
        Assert.assertEquals((long)0L, (long)reasoner.getEquivalentClasses((ElkClassExpression)queryExpression).getMembers().size());
    }
}

