/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.BaseReasoningCorrectnessTest;
import org.semanticweb.elk.reasoner.ClassTaxonomyTestOutput;
import org.semanticweb.elk.reasoner.ReasoningTestManifest;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.testing.PolySuite;
import org.semanticweb.elk.testing.TestOutput;
import org.semanticweb.elk.testing.TestResultComparisonException;

@RunWith(value=PolySuite.class)
public abstract class BaseClassificationCorrectnessTest<EO extends TestOutput>
extends BaseReasoningCorrectnessTest<EO, ClassTaxonomyTestOutput> {
    static final String INPUT_DATA_LOCATION = "classification_test_input";

    public BaseClassificationCorrectnessTest(ReasoningTestManifest<EO, ClassTaxonomyTestOutput> testManifest) {
        super(testManifest);
    }

    @Test
    public void classify() throws TestResultComparisonException, ElkException {
        Taxonomy taxonomy = this.reasoner.getTaxonomyQuietly();
        this.manifest.compare(new ClassTaxonomyTestOutput((Taxonomy<ElkClass>)taxonomy));
    }

    @Test
    public void classifyWithInterruptions() throws TestResultComparisonException, ElkException {
        ReasoningProcess reasoningProcess = new ReasoningProcess();
        Thread reasonerThread = new Thread((Runnable)reasoningProcess, "test-elk-reasoner-thread");
        reasonerThread.start();
        while (reasonerThread.isAlive()) {
            this.reasoner.interrupt();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Assert.fail();
            }
        }
        if (reasoningProcess.exception != null) {
            throw reasoningProcess.exception;
        }
        this.manifest.compare(new ClassTaxonomyTestOutput(reasoningProcess.getTaxonomy()));
    }

    class ReasoningProcess
    implements Runnable {
        Taxonomy<ElkClass> taxonomy = null;
        ElkException exception = null;

        ReasoningProcess() {
        }

        @Override
        public void run() {
            try {
                this.taxonomy = BaseClassificationCorrectnessTest.this.reasoner.getTaxonomyQuietly();
            }
            catch (ElkException e) {
                this.exception = e;
            }
        }

        public Taxonomy<ElkClass> getTaxonomy() {
            return this.taxonomy;
        }
    }
}

