/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.loading;

import java.io.Reader;
import java.io.StringReader;
import org.junit.After;
import org.junit.Test;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.loading.Owl2ParserLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;

public class Owl2ParserLoaderTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String ontology) throws ElkLoadingException {
        StringReader reader = new StringReader(ontology);
        try {
            Owl2ParserLoader loader = new Owl2ParserLoader(new Owl2FunctionalStyleParserFactory().getParser((Reader)reader));
            ElkAxiomProcessor dummyProcessor = new ElkAxiomProcessor(){

                public void visit(ElkAxiom elkAxiom) {
                }
            };
            loader.load(dummyProcessor, dummyProcessor);
        }
        finally {
            reader.close();
        }
    }

    @Test(expected=ElkLoadingException.class)
    public void expectedLoadingExceptionOnSyntaxError() throws ElkLoadingException {
        String ontology = "Prefix( : = <http://example.org/> )Ontology((((()(EquivalentClasses(:B :C)SubClassOf(:A ObjectSomeValuesFrom(:R :B))))";
        this.load(ontology);
    }

    @Test(expected=ElkLoadingException.class)
    public void expectedLoadingExceptionOnLexicalError() throws Exception {
        String ontology = "Prefix( : = <http://example.org/> )Ontology-LEXICAL-ERROR(EquivalentClasses(:B :C)SubClassOf(:A ObjectSomeValuesFrom(:R :B)))";
        this.load(ontology);
    }

    @After
    public void cleanUp() {
        Thread.interrupted();
    }
}

