/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.hashing;

import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.hashing.NodeHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.hashing.HashGenerator;
import org.semanticweb.elk.util.hashing.Hasher;

public class TypeNodeHasher
implements Hasher<TypeNode<? extends ElkEntity, ? extends ElkEntity>> {
    public static TypeNodeHasher INSTANCE = new TypeNodeHasher();

    private TypeNodeHasher() {
    }

    public int hash(TypeNode<? extends ElkEntity, ? extends ElkEntity> node) {
        int memberHash = NodeHasher.INSTANCE.hash(node);
        int subClassHash = "subClassOf".hashCode();
        for (TypeNode<? extends ElkEntity, ? extends ElkEntity> o : node.getDirectSubNodes()) {
            subClassHash = HashGenerator.combineMultisetHash((boolean)false, (int[])new int[]{subClassHash, NodeHasher.INSTANCE.hash(o)});
        }
        int superClassHash = "superClassOf".hashCode();
        for (TypeNode<? extends ElkEntity, ? extends ElkEntity> o : node.getDirectSuperNodes()) {
            superClassHash = HashGenerator.combineMultisetHash((boolean)false, (int[])new int[]{superClassHash, NodeHasher.INSTANCE.hash(o)});
        }
        int instanceHash = "instanceOf".hashCode();
        for (InstanceNode<? extends ElkEntity, ? extends ElkEntity> o : node.getDirectInstanceNodes()) {
            instanceHash = HashGenerator.combineMultisetHash((boolean)false, (int[])new int[]{instanceHash, NodeHasher.INSTANCE.hash(o)});
        }
        return HashGenerator.combineListHash((int[])new int[]{memberHash, subClassHash, superClassHash, instanceHash});
    }
}

