/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.hashing;

import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.hashing.NodeHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.util.hashing.HashGenerator;
import org.semanticweb.elk.util.hashing.Hasher;

public class TaxonomyNodeHasher
implements Hasher<TaxonomyNode<? extends ElkEntity>> {
    public static TaxonomyNodeHasher INSTANCE = new TaxonomyNodeHasher();

    private TaxonomyNodeHasher() {
    }

    public int hash(TaxonomyNode<? extends ElkEntity> node) {
        int memberHash = NodeHasher.INSTANCE.hash(node);
        int subClassHash = "subClassOf".hashCode();
        for (TaxonomyNode<? extends ElkEntity> o : node.getDirectSubNodes()) {
            subClassHash = HashGenerator.combineMultisetHash((boolean)false, (int[])new int[]{subClassHash, NodeHasher.INSTANCE.hash(o)});
        }
        int superClassHash = "superClassOf".hashCode();
        for (TaxonomyNode<? extends ElkEntity> o : node.getDirectSuperNodes()) {
            superClassHash = HashGenerator.combineMultisetHash((boolean)false, (int[])new int[]{superClassHash, NodeHasher.INSTANCE.hash(o)});
        }
        return HashGenerator.combineListHash((int[])new int[]{memberHash, subClassHash, superClassHash});
    }
}

