/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.NonBottomClassNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.hashing.HashGenerator;

public class IndividualNode
implements InstanceNode<ElkClass, ElkNamedIndividual> {
    private static final Logger LOGGER_ = Logger.getLogger(IndividualNode.class);
    private final ConcurrentTaxonomy taxonomy_;
    private final List<ElkNamedIndividual> members_;
    private final Set<TypeNode<ElkClass, ElkNamedIndividual>> directTypeNodes_;
    private final int hashCode_ = HashGenerator.generateNextHashCode();

    protected IndividualNode(ConcurrentTaxonomy taxonomy, Collection<ElkNamedIndividual> members) {
        this.taxonomy_ = taxonomy;
        this.members_ = new ArrayList<ElkNamedIndividual>(members);
        this.directTypeNodes_ = new ArrayHashSet();
        Collections.sort(this.members_, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR);
    }

    void addDirectTypeNode(NonBottomClassNode typeNode) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": new direct type-node " + typeNode));
        }
        this.directTypeNodes_.add(typeNode);
    }

    @Override
    public Set<ElkNamedIndividual> getMembers() {
        return new AbstractSet<ElkNamedIndividual>(){

            @Override
            public boolean contains(Object arg) {
                if (arg instanceof ElkNamedIndividual) {
                    return Collections.binarySearch(IndividualNode.this.members_, (ElkNamedIndividual)arg, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR) >= 0;
                }
                return false;
            }

            @Override
            public boolean isEmpty() {
                return IndividualNode.this.members_.isEmpty();
            }

            @Override
            public Iterator<ElkNamedIndividual> iterator() {
                return IndividualNode.this.members_.iterator();
            }

            @Override
            public int size() {
                return IndividualNode.this.members_.size();
            }
        };
    }

    @Override
    public ElkNamedIndividual getCanonicalMember() {
        return this.members_.get(0);
    }

    @Override
    public Set<TypeNode<ElkClass, ElkNamedIndividual>> getDirectTypeNodes() {
        return Collections.unmodifiableSet(this.directTypeNodes_);
    }

    @Override
    public Set<TypeNode<ElkClass, ElkNamedIndividual>> getAllTypeNodes() {
        ArrayHashSet result = new ArrayHashSet(this.directTypeNodes_.size());
        LinkedList todo = new LinkedList();
        todo.addAll(this.directTypeNodes_);
        while (!todo.isEmpty()) {
            TypeNode next = (TypeNode)todo.poll();
            if (!result.add(next)) continue;
            for (TypeNode nextSuperNode : next.getDirectSuperNodes()) {
                todo.add(nextSuperNode);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    @Override
    public InstanceTaxonomy<ElkClass, ElkNamedIndividual> getTaxonomy() {
        return this.taxonomy_;
    }

    public String toString() {
        return this.getCanonicalMember().getIri().getFullIriAsString();
    }
}

