/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeVisitor;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.util.collections.ArraySet;

public class DepthFirstSearch<T extends ElkObject> {
    public void run(TaxonomyNode<T> start, Direction dir, TaxonomyNodeVisitor<T> visitor) {
        ArraySet path = new ArraySet();
        HashSet<TaxonomyNode<T>> pathSet = new HashSet<TaxonomyNode<T>>();
        this.run(start, dir, visitor, (List<TaxonomyNode<T>>)path, (Set<TaxonomyNode<T>>)pathSet);
    }

    private void run(TaxonomyNode<T> node, Direction dir, TaxonomyNodeVisitor<T> visitor, List<TaxonomyNode<T>> path, Set<TaxonomyNode<T>> pathSet) {
        visitor.visit(node, path);
        if (pathSet.contains(node)) {
            return;
        }
        path.add(node);
        pathSet.add(node);
        for (TaxonomyNode<T> subNode : DepthFirstSearch.getSuccessors(node, dir)) {
            this.run(subNode, dir, visitor, path, pathSet);
        }
        path.remove(path.size() - 1);
        pathSet.remove(node);
    }

    protected static <U extends ElkObject> Set<? extends TaxonomyNode<U>> getSuccessors(TaxonomyNode<U> node, Direction dir) {
        switch (dir) {
            case UP: {
                return node.getDirectSuperNodes();
            }
            case DOWN: {
                return node.getDirectSubNodes();
            }
        }
        return Collections.emptySet();
    }

    public static enum Direction {
        UP{

            @Override
            public Direction reverse() {
                return DOWN;
            }
        }
        ,
        DOWN{

            @Override
            public Direction reverse() {
                return UP;
            }
        };


        public abstract Direction reverse();
    }
}

