/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.reasoner.taxonomy.IndividualClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.IndividualNode;
import org.semanticweb.elk.reasoner.taxonomy.NonBottomClassNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.collections.Operations;

class ConcurrentTaxonomy
extends IndividualClassTaxonomy {
    private static final Logger LOGGER_ = Logger.getLogger(ConcurrentTaxonomy.class);
    private final ConcurrentMap<ElkIri, NonBottomClassNode> classNodeLookup_ = new ConcurrentHashMap<ElkIri, NonBottomClassNode>();
    private final Set<TypeNode<ElkClass, ElkNamedIndividual>> allClassNodes_ = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<ElkIri, IndividualNode> individualNodeLookup_ = new ConcurrentHashMap<ElkIri, IndividualNode>();
    private final Set<InstanceNode<ElkClass, ElkNamedIndividual>> allIndividualNodes_ = Collections.newSetFromMap(new ConcurrentHashMap());
    final AtomicInteger countNodesWithSubClasses;
    final Set<ElkClass> unsatisfiableClasses;
    final BottomClassNode bottomClassNode = new BottomClassNode();

    ConcurrentTaxonomy() {
        this.allClassNodes_.add(this.bottomClassNode);
        this.countNodesWithSubClasses = new AtomicInteger(0);
        this.unsatisfiableClasses = Collections.synchronizedSet(new TreeSet(Comparators.ELK_CLASS_COMPARATOR));
        this.unsatisfiableClasses.add((ElkClass)PredefinedElkClass.OWL_NOTHING);
    }

    static ElkIri getKey(ElkEntity elkEntity) {
        return elkEntity.getIri();
    }

    @Override
    public TypeNode<ElkClass, ElkNamedIndividual> getTypeNode(ElkClass elkClass) {
        TypeNode result = (TypeNode)this.classNodeLookup_.get(ConcurrentTaxonomy.getKey((ElkEntity)elkClass));
        if (result == null && this.unsatisfiableClasses.contains(elkClass)) {
            result = this.bottomClassNode;
        }
        return result;
    }

    @Override
    public InstanceNode<ElkClass, ElkNamedIndividual> getInstanceNode(ElkNamedIndividual individual) {
        return (InstanceNode)this.individualNodeLookup_.get(ConcurrentTaxonomy.getKey((ElkEntity)individual));
    }

    @Override
    public TaxonomyNode<ElkClass> getNode(ElkClass elkClass) {
        return this.getTypeNode(elkClass);
    }

    @Override
    public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getTypeNodes() {
        return Collections.unmodifiableSet(this.allClassNodes_);
    }

    @Override
    public Set<? extends InstanceNode<ElkClass, ElkNamedIndividual>> getInstanceNodes() {
        return Collections.unmodifiableSet(this.allIndividualNodes_);
    }

    @Override
    public Set<? extends TaxonomyNode<ElkClass>> getNodes() {
        return this.getTypeNodes();
    }

    @Override
    public TypeNode<ElkClass, ElkNamedIndividual> getTopNode() {
        return this.getTypeNode((ElkClass)PredefinedElkClass.OWL_THING);
    }

    @Override
    public TypeNode<ElkClass, ElkNamedIndividual> getBottomNode() {
        return this.bottomClassNode;
    }

    @Override
    NonBottomClassNode getCreateClassNode(Collection<ElkClass> members) {
        ElkClass someMember = members.iterator().next();
        NonBottomClassNode previous = (NonBottomClassNode)this.classNodeLookup_.get(ConcurrentTaxonomy.getKey((ElkEntity)someMember));
        if (previous != null) {
            return previous;
        }
        NonBottomClassNode node = new NonBottomClassNode(this, members);
        ElkClass canonical = node.getCanonicalMember();
        previous = this.classNodeLookup_.putIfAbsent(ConcurrentTaxonomy.getKey((ElkEntity)canonical), node);
        if (previous != null) {
            return previous;
        }
        this.allClassNodes_.add(node);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(OwlFunctionalStylePrinter.toString((ElkObject)canonical) + ": node created"));
        }
        for (ElkClass member : members) {
            if (member == canonical) continue;
            this.classNodeLookup_.put(ConcurrentTaxonomy.getKey((ElkEntity)member), node);
        }
        return node;
    }

    @Override
    IndividualNode getCreateIndividualNode(Collection<ElkNamedIndividual> members) {
        IndividualNode node = new IndividualNode(this, members);
        ElkNamedIndividual canonical = node.getCanonicalMember();
        IndividualNode previous = this.individualNodeLookup_.putIfAbsent(ConcurrentTaxonomy.getKey((ElkEntity)canonical), node);
        if (previous != null) {
            return previous;
        }
        this.allIndividualNodes_.add(node);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(OwlFunctionalStylePrinter.toString((ElkObject)canonical) + ": node created"));
        }
        for (ElkNamedIndividual member : members) {
            if (member == canonical) continue;
            this.individualNodeLookup_.put(ConcurrentTaxonomy.getKey((ElkEntity)member), node);
        }
        return node;
    }

    @Override
    void addUnsatisfiableClass(ElkClass elkClass) {
        this.unsatisfiableClasses.add(elkClass);
    }

    protected class BottomClassNode
    implements TypeNode<ElkClass, ElkNamedIndividual> {
        protected BottomClassNode() {
        }

        @Override
        public Set<ElkClass> getMembers() {
            return ConcurrentTaxonomy.this.unsatisfiableClasses;
        }

        @Override
        public ElkClass getCanonicalMember() {
            return PredefinedElkClass.OWL_NOTHING;
        }

        @Override
        public Set<TypeNode<ElkClass, ElkNamedIndividual>> getDirectSuperNodes() {
            return Operations.filter((Set)ConcurrentTaxonomy.this.allClassNodes_, (Operations.Condition)new Operations.Condition<TaxonomyNode<ElkClass>>(){

                public boolean holds(TaxonomyNode<ElkClass> element) {
                    return element.getDirectSubNodes().contains(ConcurrentTaxonomy.this.bottomClassNode);
                }
            }, (int)(ConcurrentTaxonomy.this.allClassNodes_.size() - ConcurrentTaxonomy.this.countNodesWithSubClasses.get() - 1));
        }

        @Override
        public Set<TypeNode<ElkClass, ElkNamedIndividual>> getAllSuperNodes() {
            return Operations.filter((Set)ConcurrentTaxonomy.this.allClassNodes_, (Operations.Condition)new Operations.Condition<Object>(){

                public boolean holds(Object element) {
                    return element != ConcurrentTaxonomy.this.bottomClassNode;
                }
            }, (int)(ConcurrentTaxonomy.this.allClassNodes_.size() - 1));
        }

        @Override
        public Set<TypeNode<ElkClass, ElkNamedIndividual>> getDirectSubNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<TypeNode<ElkClass, ElkNamedIndividual>> getAllSubNodes() {
            return Collections.emptySet();
        }

        @Override
        public InstanceTaxonomy<ElkClass, ElkNamedIndividual> getTaxonomy() {
            return ConcurrentTaxonomy.this;
        }

        @Override
        public Set<InstanceNode<ElkClass, ElkNamedIndividual>> getDirectInstanceNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<InstanceNode<ElkClass, ElkNamedIndividual>> getAllInstanceNodes() {
            return Collections.emptySet();
        }
    }
}

