/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionFactory;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionJob;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionListener;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutput;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalent;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputUnsatisfiable;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputVisitor;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.IndividualClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.NonBottomClassNode;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class ClassTaxonomyComputationFactory
implements InputProcessorFactory<IndexedClass, Engine> {
    private final IndividualClassTaxonomy taxonomy_;
    private final TransitiveReductionFactory<IndexedClass, TransitiveReductionJob<IndexedClass>> transitiveReductionShared_;
    private final TransitiveReductionOutputProcessor outputProcessor_;
    private final AtomicReference<NonBottomClassNode> topNodeRef_;

    public ClassTaxonomyComputationFactory(OntologyIndex ontologyIndex, int maxWorkers, IndividualClassTaxonomy partialTaxonomy) {
        this.taxonomy_ = partialTaxonomy;
        this.transitiveReductionShared_ = new TransitiveReductionFactory(ontologyIndex, maxWorkers, new ThisTransitiveReductionListener());
        this.outputProcessor_ = new TransitiveReductionOutputProcessor();
        this.topNodeRef_ = new AtomicReference();
    }

    public ClassTaxonomyComputationFactory(OntologyIndex ontologyIndex, int maxWorkers) {
        this(ontologyIndex, maxWorkers, new ConcurrentTaxonomy());
    }

    NonBottomClassNode getCreateTopNode() {
        if (this.topNodeRef_.get() == null) {
            NonBottomClassNode topNode = this.taxonomy_.getCreateClassNode(Collections.singleton(PredefinedElkClass.OWL_THING));
            this.topNodeRef_.compareAndSet(null, topNode);
        }
        return this.topNodeRef_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assignDirectSuperClassNode(NonBottomClassNode subNode, NonBottomClassNode superNode) {
        subNode.addDirectSuperNode(superNode);
        NonBottomClassNode nonBottomClassNode = superNode;
        synchronized (nonBottomClassNode) {
            superNode.addDirectSubNode(subNode);
        }
    }

    public IndividualClassTaxonomy getTaxonomy() {
        return this.taxonomy_;
    }

    public void printStatistics() {
        this.transitiveReductionShared_.printStatistics();
    }

    public Engine getEngine() {
        return new Engine();
    }

    public class Engine
    implements InputProcessor<IndexedClass> {
        protected final TransitiveReductionFactory.Engine transitiveReductionEngine;

        private Engine() {
            this.transitiveReductionEngine = ClassTaxonomyComputationFactory.this.transitiveReductionShared_.getEngine();
        }

        public final void submit(IndexedClass job) {
            this.transitiveReductionEngine.submit(new TransitiveReductionJob<IndexedClass>(job));
        }

        public final void process() throws InterruptedException {
            this.transitiveReductionEngine.process();
        }

        public void finish() {
            this.transitiveReductionEngine.finish();
        }
    }

    private class TransitiveReductionOutputProcessor
    implements TransitiveReductionOutputVisitor<IndexedClass> {
        private TransitiveReductionOutputProcessor() {
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalentDirect<IndexedClass> output) {
            NonBottomClassNode node = ClassTaxonomyComputationFactory.this.taxonomy_.getCreateClassNode(output.getEquivalent());
            if (node.getMembers().contains(PredefinedElkClass.OWL_THING)) {
                ClassTaxonomyComputationFactory.this.topNodeRef_.compareAndSet(null, node);
                return;
            }
            for (TransitiveReductionOutputEquivalent<IndexedClass> directSuperEquivalent : output.getDirectSuperClasses()) {
                NonBottomClassNode superNode = ClassTaxonomyComputationFactory.this.taxonomy_.getCreateClassNode(directSuperEquivalent.getEquivalent());
                ClassTaxonomyComputationFactory.assignDirectSuperClassNode(node, superNode);
            }
            if (node.getDirectSuperNodes().isEmpty()) {
                NonBottomClassNode topNode = ClassTaxonomyComputationFactory.this.getCreateTopNode();
                ClassTaxonomyComputationFactory.assignDirectSuperClassNode(node, topNode);
            }
        }

        @Override
        public void visit(TransitiveReductionOutputUnsatisfiable<IndexedClass> output) {
            ClassTaxonomyComputationFactory.this.taxonomy_.addUnsatisfiableClass(((IndexedClass)output.getRoot()).getElkClass());
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalent<IndexedClass> output) {
            throw new IllegalArgumentException();
        }
    }

    private class ThisTransitiveReductionListener
    implements TransitiveReductionListener<TransitiveReductionJob<IndexedClass>, TransitiveReductionFactory.Engine> {
        private ThisTransitiveReductionListener() {
        }

        public void notifyFinished(TransitiveReductionJob<IndexedClass> job) throws InterruptedException {
            ((TransitiveReductionOutput)job.getOutput()).accept(ClassTaxonomyComputationFactory.this.outputProcessor_);
        }
    }
}

