/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;
import org.semanticweb.elk.util.logging.Statistics;

public class RestartingStageExecutor
extends SimpleInterrupter
implements ReasonerStageExecutor {
    private static final Logger LOGGER_ = Logger.getLogger(RestartingStageExecutor.class);

    @Override
    public void complete(ReasonerStage stage) throws ElkException {
        if (!stage.done()) {
            LOGGER_.debug((Object)(stage.getName() + " stage:"));
            for (ReasonerStage dependentStage : stage.getDependencies()) {
                this.complete(dependentStage);
            }
            Statistics.logOperationStart((String)stage.getName(), (Logger)LOGGER_);
            this.registerCurrentThreadToInterrupt();
            while (true) {
                try {
                    stage.execute();
                }
                catch (ElkException e) {
                    if (e instanceof ElkInterruptedException) {
                        stage.clearInterrupt();
                        continue;
                    }
                    throw e;
                }
                finally {
                    this.finish(stage);
                    continue;
                }
                break;
            }
        }
    }

    private void finish(ReasonerStage stage) {
        this.clearThreadToInterrupt();
        Statistics.logOperationFinish((String)stage.getName(), (Logger)LOGGER_);
        Statistics.logMemoryUsage((Logger)LOGGER_);
        stage.printInfo();
    }
}

