/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ClassTaxonomyComputationStage;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.reasoner.taxonomy.InstanceTaxonomyComputation;

class InstanceTaxonomyComputationStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(InstanceTaxonomyComputationStage.class);
    private InstanceTaxonomyComputation computation = null;

    public InstanceTaxonomyComputationStage(AbstractReasonerState reasoner) {
        super(reasoner);
    }

    @Override
    public String getName() {
        return "Instance Taxonomy Computation";
    }

    @Override
    public boolean done() {
        return this.reasoner.doneInstanceTaxonomy;
    }

    public List<ReasonerStage> getDependencies() {
        return Arrays.asList(new ClassTaxonomyComputationStage(this.reasoner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ElkInterruptedException {
        if (this.computation == null) {
            this.initComputation();
        }
        this.progressMonitor.start(this.getName());
        try {
            do {
                this.computation.process();
            } while (this.interrupted());
        }
        finally {
            this.progressMonitor.finish();
        }
        this.reasoner.taxonomy = this.computation.getTaxonomy();
        this.reasoner.doneInstanceTaxonomy = true;
    }

    @Override
    void initComputation() {
        super.initComputation();
        if (this.reasoner.doneClassTaxonomy) {
            this.computation = new InstanceTaxonomyComputation(this.reasoner.ontologyIndex.getIndexedIndividuals(), this.reasoner.getProcessExecutor(), this.workerNo, this.progressMonitor, this.reasoner.ontologyIndex, this.reasoner.taxonomy);
        }
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)(this.getName() + " using " + this.workerNo + " workers"));
        }
    }

    @Override
    public void printInfo() {
        if (this.computation != null) {
            this.computation.printStatistics();
        }
    }
}

