/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.consistency.ConsistencyChecking;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ContextInitializationStage;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ObjectPropertyCompositionsPrecomputationStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;

class ConsistencyCheckingStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(ConsistencyCheckingStage.class);
    private ConsistencyChecking computation = null;

    public ConsistencyCheckingStage(AbstractReasonerState reasoner) {
        super(reasoner);
    }

    @Override
    public String getName() {
        return "Consistency Checking";
    }

    @Override
    public boolean done() {
        return this.reasoner.doneConsistencyCheck;
    }

    public List<ReasonerStage> getDependencies() {
        return Arrays.asList(new ObjectPropertyCompositionsPrecomputationStage(this.reasoner), new ContextInitializationStage(this.reasoner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ElkInterruptedException {
        if (this.computation == null) {
            this.initComputation();
        }
        this.progressMonitor.start(this.getName());
        try {
            do {
                this.computation.process();
            } while (this.interrupted());
        }
        finally {
            this.progressMonitor.finish();
        }
        this.reasoner.consistentOntology = this.computation.isConsistent();
        this.reasoner.doneConsistencyCheck = true;
    }

    @Override
    void initComputation() {
        super.initComputation();
        this.computation = new ConsistencyChecking(this.reasoner.getProcessExecutor(), this.workerNo, this.reasoner.getProgressMonitor(), this.reasoner.ontologyIndex);
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)(this.getName() + " using " + this.workerNo + " workers"));
        }
    }

    @Override
    public void printInfo() {
        if (this.computation != null) {
            this.computation.printStatistics();
        }
    }
}

