/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.Loader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.OntologyLoadingStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;

public class ChangesLoadingStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(ChangesLoadingStage.class);

    public ChangesLoadingStage(AbstractReasonerState reasoner) {
        super(reasoner);
    }

    @Override
    public String getName() {
        return "Loading of Changes";
    }

    @Override
    public boolean done() {
        return this.reasoner.doneChangeLoading;
    }

    @Override
    public Iterable<ReasonerStage> getDependencies() {
        return Arrays.asList(new OntologyLoadingStage(this.reasoner));
    }

    @Override
    public void execute() throws ElkException {
        this.initComputation();
        Loader changesLoader = this.reasoner.getChangesLoader();
        if (changesLoader == null) {
            LOGGER_.warn((Object)"Ontology changes loader is not registered. No changes will be loaded!");
        } else {
            do {
                changesLoader.load();
            } while (this.interrupted());
        }
        this.reasoner.doneChangeLoading = true;
    }

    @Override
    public void printInfo() {
    }
}

