/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.ChangesLoader;
import org.semanticweb.elk.loading.Loader;
import org.semanticweb.elk.loading.OntologyLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.OntologyIndexImpl;
import org.semanticweb.elk.reasoner.stages.ChangesLoadingStage;
import org.semanticweb.elk.reasoner.stages.ClassTaxonomyComputationStage;
import org.semanticweb.elk.reasoner.stages.ConsistencyCheckingStage;
import org.semanticweb.elk.reasoner.stages.InstanceTaxonomyComputationStage;
import org.semanticweb.elk.reasoner.stages.OntologyLoadingStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.IndividualClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;

public abstract class AbstractReasonerState {
    private static final Logger LOGGER_ = Logger.getLogger(AbstractReasonerState.class);
    boolean doneLoading = false;
    boolean doneChangeLoading = false;
    boolean doneObjectPropertyHierarchyComputation = false;
    boolean doneObjectPropertyCompositionsPrecomputation = false;
    boolean doneContextReset = true;
    boolean doneConsistencyCheck = false;
    boolean doneClassTaxonomy = false;
    boolean doneInstanceTaxonomy = false;
    private volatile boolean isInterrupted_ = false;
    final OntologyIndex ontologyIndex = new OntologyIndexImpl();
    boolean consistentOntology = true;
    IndividualClassTaxonomy taxonomy = null;
    private Loader ontologyLoader;
    private Loader changesLoader;

    protected AbstractReasonerState() {
    }

    private void resetLoading() {
        if (this.ontologyLoader != null) {
            this.ontologyLoader.dispose();
            this.ontologyLoader = null;
        }
        if (this.doneLoading) {
            this.doneLoading = false;
            this.ontologyIndex.clear();
        }
        this.resetChangesLoading();
    }

    private void resetChangesLoading() {
        if (this.changesLoader != null) {
            this.changesLoader.dispose();
            this.changesLoader = null;
        }
        if (this.doneChangeLoading) {
            this.doneChangeLoading = false;
            this.doneObjectPropertyHierarchyComputation = false;
            this.doneObjectPropertyCompositionsPrecomputation = false;
            this.doneContextReset = false;
            this.doneConsistencyCheck = false;
            this.doneClassTaxonomy = false;
            this.doneInstanceTaxonomy = false;
        }
    }

    public void registerOntologyLoader(OntologyLoader ontologyLoader) {
        this.resetLoading();
        this.ontologyLoader = ontologyLoader.getLoader(this.ontologyIndex.getAxiomInserter());
    }

    public void registerOntologyChangesLoader(ChangesLoader changesLoader) {
        this.resetChangesLoading();
        this.changesLoader = changesLoader.getLoader(this.ontologyIndex.getAxiomInserter(), this.ontologyIndex.getAxiomDeleter());
    }

    Loader getOntologyLoader() {
        return this.ontologyLoader;
    }

    Loader getChangesLoader() {
        return this.changesLoader;
    }

    protected abstract int getNumberOfWorkers();

    protected abstract ReasonerStageExecutor getStageExecutor();

    protected abstract ComputationExecutor getProcessExecutor();

    protected abstract ProgressMonitor getProgressMonitor();

    public void reset() {
        this.resetLoading();
    }

    public void interrupt() {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)"Interrupt requested");
        }
        this.isInterrupted_ = true;
        ReasonerStageExecutor stageExecutor = this.getStageExecutor();
        if (stageExecutor != null) {
            stageExecutor.interrupt();
        }
    }

    public boolean isInterrupted() {
        return this.isInterrupted_;
    }

    public void clearInterrupt() {
        this.isInterrupted_ = false;
    }

    public boolean isConsistent() throws ElkException {
        this.getStageExecutor().complete(new ConsistencyCheckingStage(this));
        return this.consistentOntology;
    }

    public boolean doneConsistencyCheck() {
        return this.doneConsistencyCheck;
    }

    public void loadOntology() throws ElkException {
        this.getStageExecutor().complete(new OntologyLoadingStage(this));
    }

    public void loadChanges() throws ElkException {
        this.getStageExecutor().complete(new ChangesLoadingStage(this));
    }

    public Taxonomy<ElkClass> getTaxonomy() throws ElkException {
        if (!this.isConsistent()) {
            throw new ElkInconsistentOntologyException();
        }
        this.getStageExecutor().complete(new ClassTaxonomyComputationStage(this));
        return this.taxonomy;
    }

    public boolean doneTaxonomy() {
        return this.doneClassTaxonomy;
    }

    public InstanceTaxonomy<ElkClass, ElkNamedIndividual> getInstanceTaxonomy() throws ElkException {
        if (!this.isConsistent()) {
            throw new ElkInconsistentOntologyException();
        }
        this.getStageExecutor().complete(new InstanceTaxonomyComputationStage(this));
        return this.taxonomy;
    }

    public boolean doneInstanceTaxonomy() {
        return this.doneInstanceTaxonomy;
    }

    protected OntologyIndex getOntologyIndex() throws ElkException {
        this.getStageExecutor().complete(new OntologyLoadingStage(this));
        return this.ontologyIndex;
    }
}

