/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rulesystem;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.saturation.classes.InferenceSystemElClassSaturation;
import org.semanticweb.elk.reasoner.saturation.classes.InferenceSystemInvocationManagerSCE;
import org.semanticweb.elk.reasoner.saturation.classes.RuleStatistics;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Context;
import org.semanticweb.elk.reasoner.saturation.rulesystem.IllegalInferenceMethodException;
import org.semanticweb.elk.reasoner.saturation.rulesystem.InferenceSystem;
import org.semanticweb.elk.reasoner.saturation.rulesystem.InferenceSystemInvocationManager;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Queueable;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class RuleApplicationFactory
implements InputProcessorFactory<IndexedClassExpression, Engine> {
    private static final Logger LOGGER_ = Logger.getLogger(RuleApplicationFactory.class);
    private final InferenceSystem<? extends Context> inferenceSystem;
    private final InferenceSystemInvocationManager inferenceSystemInvocationManager;
    private final OntologyIndex ontologyIndex;
    private final IndexedClassExpression owlThing;
    private final IndexedClassExpression owlNothing;
    private final Queue<Context> activeContexts;
    protected final AtomicInteger approximateContextNumber = new AtomicInteger(0);
    private final int contextUpdateInterval = 32;
    private final RuleStatistics aggregatedStatistics;

    public RuleApplicationFactory(OntologyIndex ontologyIndex) {
        this.inferenceSystem = new InferenceSystemElClassSaturation();
        this.inferenceSystemInvocationManager = new InferenceSystemInvocationManagerSCE();
        this.ontologyIndex = ontologyIndex;
        this.activeContexts = new ConcurrentLinkedQueue<Context>();
        this.aggregatedStatistics = new RuleStatistics();
        this.owlThing = ontologyIndex.getIndexed((ElkClassExpression)PredefinedElkClass.OWL_THING);
        this.owlNothing = ontologyIndex.getIndexed((ElkClassExpression)PredefinedElkClass.OWL_NOTHING);
        try {
            this.inferenceSystemInvocationManager.addInferenceSystem(this.inferenceSystem);
        }
        catch (IllegalInferenceMethodException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public int getApproximateContextNumber() {
        return this.approximateContextNumber.get();
    }

    public void printStatistics() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)("Contexts created:" + this.approximateContextNumber));
            LOGGER_.debug((Object)("Derived Produced/Unique:" + this.aggregatedStatistics.getSuperClassExpressionInfNo() + "/" + this.aggregatedStatistics.getSuperClassExpressionNo()));
            LOGGER_.debug((Object)("Backward Links Produced/Unique:" + this.aggregatedStatistics.getBackLinkInfNo() + "/" + this.aggregatedStatistics.getBackLinkNo()));
            LOGGER_.debug((Object)("Forward Links Produced/Unique:" + this.aggregatedStatistics.getForwLinkInfNo() + "/" + this.aggregatedStatistics.getForwLinkNo()));
        }
    }

    public Engine getEngine() {
        return new Engine();
    }

    public class Engine
    implements InputProcessor<IndexedClassExpression> {
        private final RuleStatistics statistics = new RuleStatistics();
        private int localContextNumber = 0;

        private Engine() {
        }

        public void submit(IndexedClassExpression job) {
            this.getCreateContext(job);
        }

        public void process() {
            Context nextContext;
            while (!Thread.currentThread().isInterrupted() && (nextContext = (Context)RuleApplicationFactory.this.activeContexts.poll()) != null) {
                this.process(nextContext);
            }
        }

        public void finish() {
            RuleApplicationFactory.this.approximateContextNumber.addAndGet(this.localContextNumber);
            this.localContextNumber = 0;
            RuleApplicationFactory.this.aggregatedStatistics.merge(this.statistics);
        }

        public IndexedClassExpression getOwlNothing() {
            return RuleApplicationFactory.this.owlNothing;
        }

        public IndexedClassExpression getOwlThing() {
            return RuleApplicationFactory.this.owlThing;
        }

        public Iterable<IndexedObjectProperty> getReflexiveObjectProperties() {
            return RuleApplicationFactory.this.ontologyIndex.getReflexiveObjectProperties();
        }

        public RuleStatistics getRuleStatistics() {
            return this.statistics;
        }

        public Context getCreateContext(IndexedClassExpression root) {
            Object context;
            if (root.getContext() == null && root.setContext((Context)(context = RuleApplicationFactory.this.inferenceSystem.createContext(root)))) {
                if (++this.localContextNumber == 32) {
                    RuleApplicationFactory.this.approximateContextNumber.addAndGet(this.localContextNumber);
                    this.localContextNumber = 0;
                }
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)(root + ": context created"));
                }
                RuleApplicationFactory.this.inferenceSystemInvocationManager.initContext((Context)context, this);
            }
            return root.getContext();
        }

        public void enqueue(Context context, Queueable<?> item) {
            context.getToDo().add(item);
            this.activateContext(context);
        }

        protected void process(Context context) {
            Queueable<?> item;
            while ((item = context.getToDo().poll()) != null) {
                RuleApplicationFactory.this.inferenceSystemInvocationManager.processItemInContext(item, context, this);
            }
            this.deactivateContext(context);
        }

        private void activateContext(Context context) {
            if (context.tryActivate()) {
                RuleApplicationFactory.this.activeContexts.add(context);
            }
        }

        private void deactivateContext(Context context) {
            if (context.tryDeactivate() && !context.getToDo().isEmpty()) {
                this.activateContext(context);
            }
        }
    }
}

