/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rulesystem;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Context;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Queueable;

public class AbstractContext
implements Context {
    private final IndexedClassExpression root;
    private final Queue<Queueable<?>> toDo;
    private final AtomicBoolean isActive;

    public AbstractContext(IndexedClassExpression root) {
        this.root = root;
        this.toDo = new ConcurrentLinkedQueue();
        this.isActive = new AtomicBoolean(false);
    }

    @Override
    public IndexedClassExpression getRoot() {
        return this.root;
    }

    @Override
    public final Queue<Queueable<?>> getToDo() {
        return this.toDo;
    }

    @Override
    public boolean tryActivate() {
        if (this.isActive.get()) {
            return false;
        }
        return this.isActive.compareAndSet(false, true);
    }

    @Override
    public boolean tryDeactivate() {
        if (!this.isActive.get()) {
            return false;
        }
        return this.isActive.compareAndSet(true, false);
    }
}

