/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.util.collections.AbstractHashMultimap;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class ObjectPropertyCompositionsPrecomputationFactory
implements InputProcessorFactory<IndexedPropertyChain, Engine> {
    private final Engine engine = new Engine();

    ObjectPropertyCompositionsPrecomputationFactory() {
    }

    private static void eliminateImpliedCompositions(Vector<IndexedPropertyChain> v) {
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) == null) continue;
            Set<IndexedPropertyChain> superProperties = v.get(i).getSaturated().getSuperProperties();
            for (int j = 0; j < v.size(); ++j) {
                if (v.get(j) == null || j == i || !superProperties.contains(v.get(j))) continue;
                v.set(j, null);
            }
        }
        int next = 0;
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) == null) continue;
            v.set(next++, v.get(i));
        }
        v.setSize(next);
    }

    public Engine getEngine() {
        return this.engine;
    }

    class Engine
    implements InputProcessor<IndexedPropertyChain> {
        private static final boolean REPLACE_CHAINS_BY_TOLD_SUPER_PROPERTIES = true;
        private static final boolean ELIMINATE_IMPLIED_COMPOSITIONS = true;

        Engine() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submit(IndexedPropertyChain rightProperty) {
            SaturatedPropertyChain rightPropertySaturated = rightProperty.getSaturated();
            for (IndexedPropertyChain rightSuperProperty : rightProperty.getSaturated().getSuperProperties()) {
                if (rightSuperProperty.getRightChains() == null) continue;
                for (IndexedBinaryPropertyChain chain : rightSuperProperty.getRightChains()) {
                    this.registerComposition(chain, rightPropertySaturated);
                }
            }
            if (rightPropertySaturated.compositionsByLeftSubProperty == null) {
                return;
            }
            for (Map.Entry entry : rightPropertySaturated.compositionsByLeftSubProperty.entrySet()) {
                SaturatedPropertyChain leftPropertySaturated = ((IndexedPropertyChain)entry.getKey()).getSaturated();
                Vector compositions = (Vector)entry.getValue();
                SaturatedPropertyChain saturatedPropertyChain = leftPropertySaturated;
                synchronized (saturatedPropertyChain) {
                    if (leftPropertySaturated.compositionsByRightSubProperty == null) {
                        leftPropertySaturated.compositionsByRightSubProperty = new CompositionMultimap();
                    }
                    leftPropertySaturated.compositionsByRightSubProperty.put((Object)rightProperty, (Object)compositions);
                }
                ObjectPropertyCompositionsPrecomputationFactory.eliminateImpliedCompositions(compositions);
            }
        }

        public void process() throws InterruptedException {
        }

        private void registerComposition(IndexedBinaryPropertyChain chain, SaturatedPropertyChain rightPropertySaturated) {
            if (rightPropertySaturated.compositionsByLeftSubProperty == null) {
                rightPropertySaturated.compositionsByLeftSubProperty = new CompositionMultimap();
            }
            for (IndexedPropertyChain leftProperty : chain.getLeftProperty().getSaturated().getSubProperties()) {
                if (chain.getRightChains() == null) {
                    for (IndexedObjectProperty superChain : chain.getToldSuperProperties()) {
                        rightPropertySaturated.compositionsByLeftSubProperty.add((Object)leftProperty, (Object)superChain);
                    }
                    continue;
                }
                rightPropertySaturated.compositionsByLeftSubProperty.add((Object)leftProperty, (Object)chain);
            }
        }

        public void finish() {
        }

        private class CompositionMultimap
        extends AbstractHashMultimap<IndexedPropertyChain, IndexedPropertyChain> {
            private CompositionMultimap() {
            }

            protected Vector<IndexedPropertyChain> newRecord() {
                return new Vector<IndexedPropertyChain>();
            }
        }
    }
}

