/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.classes;

import org.semanticweb.elk.reasoner.saturation.classes.ContextElClassSaturation;
import org.semanticweb.elk.reasoner.saturation.classes.InferenceRuleNegSCE;
import org.semanticweb.elk.reasoner.saturation.classes.InferenceRulePosSCE;
import org.semanticweb.elk.reasoner.saturation.classes.InferenceRuleSCE;
import org.semanticweb.elk.reasoner.saturation.classes.NegativeSuperClassExpression;
import org.semanticweb.elk.reasoner.saturation.classes.PositiveSuperClassExpression;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Context;
import org.semanticweb.elk.reasoner.saturation.rulesystem.IllegalInferenceMethodException;
import org.semanticweb.elk.reasoner.saturation.rulesystem.InferenceRule;
import org.semanticweb.elk.reasoner.saturation.rulesystem.InferenceSystem;
import org.semanticweb.elk.reasoner.saturation.rulesystem.InferenceSystemInvocationManager;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Queueable;
import org.semanticweb.elk.reasoner.saturation.rulesystem.RuleApplicationFactory;

public class InferenceSystemInvocationManagerSCE<C extends ContextElClassSaturation>
extends InferenceSystemInvocationManager {
    protected RuleMethodListNegSCE rulesNegSCE = null;
    protected RuleMethodListPosSCE rulesPosSCE = null;

    protected void addInferenceRuleNegSCE(InferenceRuleNegSCE<C> inferenceRule) {
        this.rulesNegSCE = new RuleMethodListNegSCE(inferenceRule, this.rulesNegSCE);
    }

    protected void addInferenceRulePosSCE(InferenceRulePosSCE<C> inferenceRule) {
        this.rulesPosSCE = new RuleMethodListPosSCE(inferenceRule, this.rulesPosSCE);
    }

    @Override
    public void addInferenceSystem(InferenceSystem<?> inferenceSystem) throws IllegalInferenceMethodException, NoSuchMethodException {
        for (InferenceRule<?> inferenceRule : inferenceSystem.getInferenceRules()) {
            this.addInferenceRule(inferenceRule);
            if (inferenceRule instanceof InferenceRuleNegSCE) {
                this.rulesNegSCE = new RuleMethodListNegSCE((InferenceRuleNegSCE)inferenceRule, this.rulesNegSCE);
            }
            if (inferenceRule instanceof InferenceRulePosSCE) {
                this.rulesPosSCE = new RuleMethodListPosSCE((InferenceRulePosSCE)inferenceRule, this.rulesPosSCE);
            }
            if (!(inferenceRule instanceof InferenceRuleSCE)) continue;
            this.rulesNegSCE = new RuleMethodListNegSCE((InferenceRuleSCE)inferenceRule, this.rulesNegSCE);
            this.rulesPosSCE = new RuleMethodListPosSCE((InferenceRuleSCE)inferenceRule, this.rulesPosSCE);
        }
    }

    @Override
    protected void applyAdditionalMethodsToItem(Queueable<?> queueable, Context context, RuleApplicationFactory.Engine engine) {
        if (this.rulesNegSCE != null && queueable instanceof NegativeSuperClassExpression) {
            this.rulesNegSCE.invoke((NegativeSuperClassExpression)queueable, (ContextElClassSaturation)context, engine);
        }
        if (this.rulesPosSCE != null && queueable instanceof PositiveSuperClassExpression) {
            this.rulesPosSCE.invoke((PositiveSuperClassExpression)queueable, (ContextElClassSaturation)context, engine);
        }
    }

    protected class RuleMethodListPosSCE {
        InferenceRulePosSCE<C> firstInferenceRule;
        RuleMethodListPosSCE rest;

        public RuleMethodListPosSCE(InferenceRulePosSCE<C> firstInferenceRule, RuleMethodListPosSCE rest) {
            this.firstInferenceRule = firstInferenceRule;
            this.rest = rest;
        }

        public RuleMethodListPosSCE(final InferenceRuleSCE<C> firstInferenceRule, RuleMethodListPosSCE rest) {
            this.firstInferenceRule = new InferenceRulePosSCE<C>(){

                @Override
                public void applySCE(PositiveSuperClassExpression<C> argument, C context, RuleApplicationFactory.Engine engine) {
                    firstInferenceRule.applySCE(argument, context, engine);
                }
            };
            this.rest = rest;
        }

        public void invoke(PositiveSuperClassExpression<C> argument, C context, RuleApplicationFactory.Engine engine) {
            this.firstInferenceRule.applySCE(argument, context, engine);
            if (this.rest != null) {
                this.rest.invoke(argument, context, engine);
            }
        }
    }

    protected class RuleMethodListNegSCE {
        InferenceRuleNegSCE<C> firstInferenceRule;
        RuleMethodListNegSCE rest;

        public RuleMethodListNegSCE(InferenceRuleNegSCE<C> firstInferenceRule, RuleMethodListNegSCE rest) {
            this.firstInferenceRule = firstInferenceRule;
            this.rest = rest;
        }

        public RuleMethodListNegSCE(final InferenceRuleSCE<C> firstInferenceRule, RuleMethodListNegSCE rest) {
            this.firstInferenceRule = new InferenceRuleNegSCE<C>(){

                @Override
                public void applySCE(NegativeSuperClassExpression<C> argument, C context, RuleApplicationFactory.Engine engine) {
                    firstInferenceRule.applySCE(argument, context, engine);
                }
            };
            this.rest = rest;
        }

        public void invoke(NegativeSuperClassExpression<C> argument, C context, RuleApplicationFactory.Engine engine) {
            this.firstInferenceRule.applySCE(argument, context, engine);
            if (this.rest != null) {
                this.rest.invoke(argument, context, engine);
            }
        }
    }
}

