/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationJob;
import org.semanticweb.elk.reasoner.saturation.classes.ContextClassSaturation;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Context;
import org.semanticweb.elk.reasoner.saturation.rulesystem.RuleApplicationFactory;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class ClassExpressionSaturationFactory<J extends SaturationJob<? extends IndexedClassExpression>>
implements InputProcessorFactory<J, Engine> {
    private static final Logger LOGGER_ = Logger.getLogger(ClassExpressionSaturationFactory.class);
    private final ClassExpressionSaturationListener<J, Engine> listener_;
    private final RuleApplicationFactory ruleApplicationFactory_;
    private final Queue<J> jobsToDo_;
    private final Queue<J> jobsInProgress_;
    private final AtomicInteger countJobsSubmitted_ = new AtomicInteger(0);
    private final AtomicInteger countJobsProcessed_ = new AtomicInteger(0);
    private final AtomicInteger countJobsFinished_ = new AtomicInteger(0);
    private final AtomicInteger countContextsProcessed_ = new AtomicInteger(0);
    private final int threshold_;
    private volatile boolean workersWaiting_ = false;
    private final AtomicInteger countStartedWorkers_ = new AtomicInteger(0);
    private final AtomicInteger countFinishedWorkers_ = new AtomicInteger(0);
    private final AtomicInteger lastInterruptStartedWorkersSnapshot_ = new AtomicInteger(0);

    public ClassExpressionSaturationFactory(OntologyIndex ontologyIndex, int maxWorkers, ClassExpressionSaturationListener<J, Engine> listener) {
        this.threshold_ = 64 + 32 * maxWorkers;
        this.listener_ = listener;
        this.jobsToDo_ = new ConcurrentLinkedQueue<J>();
        this.jobsInProgress_ = new ConcurrentLinkedQueue<J>();
        this.ruleApplicationFactory_ = new RuleApplicationFactory(ontologyIndex);
    }

    public ClassExpressionSaturationFactory(OntologyIndex ontologyIndex, int maxWorkers) {
        this(ontologyIndex, maxWorkers, new ClassExpressionSaturationListener<J, Engine>(){

            public void notifyFinished(J job) throws InterruptedException {
            }
        });
    }

    private void processFinishedJobs() throws InterruptedException {
        int shapshotJobsFinished;
        while ((shapshotJobsFinished = this.countJobsFinished_.get()) != this.countJobsProcessed_.get()) {
            if (!this.countJobsFinished_.compareAndSet(shapshotJobsFinished, shapshotJobsFinished + 1)) continue;
            SaturationJob nextJob = (SaturationJob)this.jobsInProgress_.poll();
            IndexedClassExpression root = (IndexedClassExpression)nextJob.getInput();
            Context rootSaturation = root.getContext();
            ((ContextClassSaturation)rootSaturation).setSaturated();
            nextJob.setOutput(rootSaturation);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(root + ": saturation finished"));
            }
            this.listener_.notifyFinished(nextJob);
        }
    }

    public void printStatistics() {
        this.ruleApplicationFactory_.printStatistics();
    }

    private static boolean updateIfSmaller(AtomicInteger counter, int value) {
        int snapshotCoutner;
        do {
            if ((snapshotCoutner = counter.get()) < value) continue;
            return false;
        } while (!counter.compareAndSet(snapshotCoutner, value));
        return true;
    }

    public Engine getEngine() {
        return new Engine();
    }

    public class Engine
    implements InputProcessor<J> {
        private final RuleApplicationFactory.Engine ruleApplicationEngine_;

        private Engine() {
            this.ruleApplicationEngine_ = ClassExpressionSaturationFactory.this.ruleApplicationFactory_.getEngine();
        }

        public void submit(J job) {
            ClassExpressionSaturationFactory.this.jobsToDo_.add(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws InterruptedException {
            ClassExpressionSaturationFactory.this.countStartedWorkers_.incrementAndGet();
            this.ruleApplicationEngine_.process();
            if (Thread.currentThread().isInterrupted()) {
                ClassExpressionSaturationFactory.updateIfSmaller(ClassExpressionSaturationFactory.this.lastInterruptStartedWorkersSnapshot_, ClassExpressionSaturationFactory.this.countStartedWorkers_.get());
            }
            this.updateProcessedCounters(ClassExpressionSaturationFactory.this.countFinishedWorkers_.incrementAndGet());
            ClassExpressionSaturationFactory.this.processFinishedJobs();
            while (!Thread.currentThread().isInterrupted()) {
                int snapshotCountContextsProcessed = ClassExpressionSaturationFactory.this.countContextsProcessed_.get();
                if (ClassExpressionSaturationFactory.this.ruleApplicationFactory_.getApproximateContextNumber() - snapshotCountContextsProcessed > ClassExpressionSaturationFactory.this.threshold_) {
                    AtomicInteger atomicInteger = ClassExpressionSaturationFactory.this.countContextsProcessed_;
                    synchronized (atomicInteger) {
                        if (ClassExpressionSaturationFactory.this.countContextsProcessed_.get() > snapshotCountContextsProcessed) {
                        }
                        ClassExpressionSaturationFactory.this.workersWaiting_ = true;
                        ClassExpressionSaturationFactory.this.countContextsProcessed_.wait();
                    }
                }
                SaturationJob nextJob = (SaturationJob)ClassExpressionSaturationFactory.this.jobsToDo_.poll();
                if (nextJob == null) {
                    return;
                }
                IndexedClassExpression root = (IndexedClassExpression)nextJob.getInput();
                Context rootContext = root.getContext();
                if (rootContext != null && ((ContextClassSaturation)rootContext).isSaturated()) {
                    nextJob.setOutput(rootContext);
                    ClassExpressionSaturationFactory.this.listener_.notifyFinished(nextJob);
                    continue;
                }
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)(root + ": saturation started"));
                }
                ClassExpressionSaturationFactory.this.countStartedWorkers_.incrementAndGet();
                ClassExpressionSaturationFactory.this.jobsInProgress_.add(nextJob);
                ClassExpressionSaturationFactory.this.countJobsSubmitted_.incrementAndGet();
                this.ruleApplicationEngine_.submit(root);
                this.ruleApplicationEngine_.process();
                if (Thread.currentThread().isInterrupted()) {
                    ClassExpressionSaturationFactory.updateIfSmaller(ClassExpressionSaturationFactory.this.lastInterruptStartedWorkersSnapshot_, ClassExpressionSaturationFactory.this.countStartedWorkers_.get());
                }
                this.updateProcessedCounters(ClassExpressionSaturationFactory.this.countFinishedWorkers_.incrementAndGet());
                ClassExpressionSaturationFactory.this.processFinishedJobs();
            }
            return;
        }

        public void finish() {
            this.ruleApplicationEngine_.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateProcessedCounters(int snapshotFinishedWorkers) {
            if (ClassExpressionSaturationFactory.this.lastInterruptStartedWorkersSnapshot_.get() >= ClassExpressionSaturationFactory.this.countStartedWorkers_.get()) {
                return;
            }
            int snapshotContextNo = ClassExpressionSaturationFactory.this.ruleApplicationFactory_.getApproximateContextNumber();
            int snapshotCountJobsSubmitted = ClassExpressionSaturationFactory.this.countJobsSubmitted_.get();
            if (ClassExpressionSaturationFactory.this.countStartedWorkers_.get() > snapshotFinishedWorkers) {
                return;
            }
            ClassExpressionSaturationFactory.updateIfSmaller(ClassExpressionSaturationFactory.this.countJobsProcessed_, snapshotCountJobsSubmitted);
            boolean updatedContextsProcessed = ClassExpressionSaturationFactory.updateIfSmaller(ClassExpressionSaturationFactory.this.countContextsProcessed_, snapshotContextNo);
            if (updatedContextsProcessed && ClassExpressionSaturationFactory.this.workersWaiting_) {
                AtomicInteger atomicInteger = ClassExpressionSaturationFactory.this.countContextsProcessed_;
                synchronized (atomicInteger) {
                    ClassExpressionSaturationFactory.this.workersWaiting_ = false;
                    ClassExpressionSaturationFactory.this.countContextsProcessed_.notifyAll();
                }
            }
        }
    }
}

