/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.util.hashing.HashGenerator;

public abstract class IndexedPropertyChain {
    private List<IndexedObjectProperty> toldSuperProperties_;
    private Collection<IndexedBinaryPropertyChain> rightChains_;
    int occurrenceNo = 0;
    private final AtomicReference<SaturatedPropertyChain> saturated = new AtomicReference();
    private final int hashCode_ = HashGenerator.generateNextHashCode();

    public List<IndexedObjectProperty> getToldSuperProperties() {
        return this.toldSuperProperties_;
    }

    public abstract List<IndexedPropertyChain> getToldSubProperties();

    public Collection<IndexedBinaryPropertyChain> getRightChains() {
        return this.rightChains_;
    }

    void addToldSuperObjectProperty(IndexedObjectProperty superObjectProperty) {
        if (this.toldSuperProperties_ == null) {
            this.toldSuperProperties_ = new ArrayList<IndexedObjectProperty>(1);
        }
        this.toldSuperProperties_.add(superObjectProperty);
    }

    protected boolean removeToldSuperObjectProperty(IndexedObjectProperty superObjectProperty) {
        boolean success = false;
        if (this.toldSuperProperties_ != null) {
            success = this.toldSuperProperties_.remove(superObjectProperty);
            if (this.toldSuperProperties_.isEmpty()) {
                this.toldSuperProperties_ = null;
            }
        }
        return success;
    }

    protected void addRightChain(IndexedBinaryPropertyChain chain) {
        if (this.rightChains_ == null) {
            this.rightChains_ = new ArrayList<IndexedBinaryPropertyChain>(1);
        }
        this.rightChains_.add(chain);
    }

    protected boolean removeRightChain(IndexedBinaryPropertyChain chain) {
        boolean success = false;
        if (this.rightChains_ != null) {
            success = this.rightChains_.remove(chain);
            if (this.rightChains_.isEmpty()) {
                this.rightChains_ = null;
            }
        }
        return success;
    }

    abstract void updateOccurrenceNumber(int var1);

    public boolean occurs() {
        return this.occurrenceNo > 0;
    }

    public SaturatedPropertyChain getSaturated() {
        return this.saturated.get();
    }

    public boolean setSaturated(SaturatedPropertyChain saturatedObjectProperty) {
        return this.saturated.compareAndSet(null, saturatedObjectProperty);
    }

    public void resetSaturated() {
        this.saturated.set(null);
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    public abstract <O> O accept(IndexedPropertyChainVisitor<O> var1);

    public abstract String toString();
}

