/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ListIterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataHasValue;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasValue;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkIndividualVisitor;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.AbstractElkObjectIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDataHasValue;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectFilter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.util.logging.ElkMessage;

public class ElkObjectIndexerVisitor
extends AbstractElkObjectIndexerVisitor {
    private static final Logger LOGGER_ = Logger.getLogger(ElkObjectIndexerVisitor.class);
    protected IndexedObjectFilter objectFilter;

    public ElkObjectIndexerVisitor(IndexedObjectFilter objectFilter) {
        this.objectFilter = objectFilter;
    }

    @Override
    public IndexedClassExpression visit(ElkClass elkClass) {
        return this.objectFilter.filter(new IndexedClass(elkClass));
    }

    @Override
    public IndexedClassExpression visit(ElkObjectHasValue elkObjectHasValue) {
        IndexedObjectProperty iop = (IndexedObjectProperty)((ElkObjectPropertyExpression)elkObjectHasValue.getProperty()).accept((ElkSubObjectPropertyExpressionVisitor)this);
        return this.objectFilter.filter(new IndexedObjectSomeValuesFrom(iop, (IndexedClassExpression)((ElkIndividual)elkObjectHasValue.getFiller()).accept((ElkIndividualVisitor)this)));
    }

    @Override
    public IndexedClassExpression visit(ElkObjectIntersectionOf elkObjectIntersectionOf) {
        IndexedClassExpression result = null;
        for (ElkClassExpression c : elkObjectIntersectionOf.getClassExpressions()) {
            IndexedClassExpression secondConjunct;
            IndexedClassExpression firstConjunct;
            IndexedClassExpression ice = (IndexedClassExpression)c.accept((ElkClassExpressionVisitor)this);
            if (result == null) {
                result = ice;
                continue;
            }
            if (result.hashCode() < ice.hashCode()) {
                firstConjunct = result;
                secondConjunct = ice;
            } else {
                firstConjunct = ice;
                secondConjunct = result;
            }
            result = this.objectFilter.filter(new IndexedObjectIntersectionOf(firstConjunct, secondConjunct));
        }
        return result;
    }

    @Override
    public IndexedClassExpression visit(ElkObjectSomeValuesFrom elkObjectSomeValuesFrom) {
        IndexedObjectProperty iop = (IndexedObjectProperty)((ElkObjectPropertyExpression)elkObjectSomeValuesFrom.getProperty()).accept((ElkSubObjectPropertyExpressionVisitor)this);
        return this.objectFilter.filter(new IndexedObjectSomeValuesFrom(iop, (IndexedClassExpression)((ElkClassExpression)elkObjectSomeValuesFrom.getFiller()).accept((ElkClassExpressionVisitor)this)));
    }

    @Override
    public IndexedClassExpression visit(ElkDataHasValue elkDataHasValue) {
        if (LOGGER_.isEnabledFor((Priority)Level.WARN)) {
            LOGGER_.warn((Object)new ElkMessage("ELK supports DataHasValue only partially. Reasoning might be incomplete.", "reasoner.indexing.dataHasValue"));
        }
        return this.objectFilter.filter(new IndexedDataHasValue(elkDataHasValue));
    }

    @Override
    public IndexedPropertyChain visit(ElkObjectProperty elkObjectProperty) {
        return this.objectFilter.filter(new IndexedObjectProperty(elkObjectProperty));
    }

    @Override
    public IndexedPropertyChain visit(ElkObjectPropertyChain elkObjectPropertyChain) {
        IndexedPropertyChain result = null;
        ListIterator iterator = elkObjectPropertyChain.getObjectPropertyExpressions().listIterator(elkObjectPropertyChain.getObjectPropertyExpressions().size());
        while (iterator.hasPrevious()) {
            IndexedObjectProperty iop = (IndexedObjectProperty)((ElkObjectPropertyExpression)iterator.previous()).accept((ElkSubObjectPropertyExpressionVisitor)this);
            if (result == null) {
                result = iop;
                continue;
            }
            result = this.objectFilter.filter(new IndexedBinaryPropertyChain(iop, result));
        }
        return result;
    }

    @Override
    public IndexedIndividual visit(ElkNamedIndividual elkNamedIndividual) {
        return (IndexedIndividual)this.objectFilter.filter(new IndexedIndividual(elkNamedIndividual));
    }
}

