/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.Arrays;
import java.util.List;
import org.semanticweb.elk.owl.AbstractElkAxiomVisitor;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationProperty;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDatatype;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkReflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owl.visitors.ElkEntityVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexingException;

public abstract class AbstractElkAxiomIndexerVisitor
extends AbstractElkAxiomVisitor<Void>
implements ElkAxiomProcessor {
    private final ElkObjectFactory objectFactory = new ElkObjectFactoryImpl();
    private final ElkEntityVisitor<Void> entityDeclarator = new ElkEntityVisitor<Void>(){

        public Void visit(ElkClass elkClass) {
            AbstractElkAxiomIndexerVisitor.this.indexClassDeclaration(elkClass);
            return null;
        }

        public Void visit(ElkDatatype elkDatatype) {
            return null;
        }

        public Void visit(ElkObjectProperty elkObjectProperty) {
            AbstractElkAxiomIndexerVisitor.this.indexObjectPropertyDeclaration(elkObjectProperty);
            return null;
        }

        public Void visit(ElkDataProperty elkDataProperty) {
            return null;
        }

        public Void visit(ElkNamedIndividual elkNamedIndividual) {
            AbstractElkAxiomIndexerVisitor.this.indexNamedIndividualDeclaration(elkNamedIndividual);
            return null;
        }

        public Void visit(ElkAnnotationProperty elkAnnotationProperty) {
            return null;
        }
    };

    public abstract void indexSubClassOfAxiom(ElkClassExpression var1, ElkClassExpression var2);

    public abstract void indexSubObjectPropertyOfAxiom(ElkSubObjectPropertyExpression var1, ElkObjectPropertyExpression var2);

    public abstract void indexClassAssertion(ElkIndividual var1, ElkClassExpression var2);

    public abstract void indexDisjointClassExpressions(List<? extends ElkClassExpression> var1);

    public abstract void indexReflexiveObjectProperty(ElkObjectPropertyExpression var1);

    public abstract IndexedClass indexClassDeclaration(ElkClass var1);

    public abstract IndexedObjectProperty indexObjectPropertyDeclaration(ElkObjectProperty var1);

    public abstract IndexedIndividual indexNamedIndividualDeclaration(ElkNamedIndividual var1);

    protected Void defaultLogicalVisit(ElkAxiom axiom) {
        throw new IndexingException((ElkObject)axiom);
    }

    public Void visit(ElkEquivalentObjectPropertiesAxiom axiom) {
        ElkObjectPropertyExpression first = null;
        for (ElkObjectPropertyExpression p : axiom.getObjectPropertyExpressions()) {
            if (first == null) {
                first = p;
                continue;
            }
            this.indexSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)first, p);
            this.indexSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)p, first);
        }
        return null;
    }

    public Void visit(ElkObjectPropertyDomainAxiom axiom) {
        this.indexSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)axiom.getProperty(), (ElkClassExpression)PredefinedElkClass.OWL_THING), (ElkClassExpression)axiom.getDomain());
        return null;
    }

    public Void visit(ElkReflexiveObjectPropertyAxiom axiom) {
        this.indexReflexiveObjectProperty((ElkObjectPropertyExpression)axiom.getProperty());
        return null;
    }

    public Void visit(ElkSubObjectPropertyOfAxiom axiom) {
        this.indexSubObjectPropertyOfAxiom(axiom.getSubObjectPropertyExpression(), axiom.getSuperObjectPropertyExpression());
        return null;
    }

    public Void visit(ElkTransitiveObjectPropertyAxiom axiom) {
        ElkObjectPropertyExpression ope = (ElkObjectPropertyExpression)axiom.getProperty();
        this.indexSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)this.objectFactory.getObjectPropertyChain(Arrays.asList(ope, ope)), ope);
        return null;
    }

    public Void visit(ElkEquivalentClassesAxiom axiom) {
        ElkClassExpression first = null;
        for (ElkClassExpression c : axiom.getClassExpressions()) {
            if (first == null) {
                first = c;
                continue;
            }
            this.indexSubClassOfAxiom(first, c);
            this.indexSubClassOfAxiom(c, first);
        }
        return null;
    }

    public Void visit(ElkSubClassOfAxiom axiom) {
        this.indexSubClassOfAxiom(axiom.getSubClassExpression(), axiom.getSuperClassExpression());
        return null;
    }

    public Void visit(ElkDisjointClassesAxiom axiom) {
        this.indexDisjointClassExpressions(axiom.getClassExpressions());
        return null;
    }

    public Void visit(ElkClassAssertionAxiom axiom) {
        this.indexClassAssertion(axiom.getIndividual(), axiom.getClassExpression());
        return null;
    }

    public Void visit(ElkObjectPropertyAssertionAxiom axiom) {
        this.indexClassAssertion((ElkIndividual)axiom.getSubject(), (ElkClassExpression)this.objectFactory.getObjectHasValue((ElkObjectPropertyExpression)axiom.getProperty(), (ElkIndividual)axiom.getObject()));
        return null;
    }

    public Void visit(ElkDeclarationAxiom axiom) {
        return (Void)axiom.getEntity().accept(this.entityDeclarator);
    }
}

