/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.loading;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.loading.Loader;
import org.semanticweb.elk.loading.OntologyLoader;
import org.semanticweb.elk.loading.Owl2ParserLoader;
import org.semanticweb.elk.owl.parsing.Owl2ParserFactory;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;

public class Owl2StreamLoader
implements OntologyLoader {
    private final Owl2ParserFactory owlParserFactory_;
    private final InputStream stream_;

    public Owl2StreamLoader(Owl2ParserFactory parserFactory, InputStream stream) {
        this.owlParserFactory_ = parserFactory;
        this.stream_ = stream;
    }

    public Owl2StreamLoader(Owl2ParserFactory parserFactory, File file) throws FileNotFoundException {
        this(parserFactory, new FileInputStream(file));
    }

    public Owl2StreamLoader(Owl2ParserFactory parserFactory, String text) {
        this(parserFactory, new ByteArrayInputStream(text.getBytes()));
    }

    @Override
    public Loader getLoader(ElkAxiomProcessor axiomLoader) {
        return new Owl2ParserLoader(this.owlParserFactory_.getParser(this.stream_), axiomLoader){

            @Override
            public void disposeParserResources() {
                super.disposeParserResources();
                try {
                    Owl2StreamLoader.this.stream_.close();
                }
                catch (IOException e) {
                    this.exception = new ElkLoadingException("Cannot close the input stream!", e);
                }
            }
        };
    }
}

