/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.semanticweb.elk.util.logging.ElkTimer;

public class Statistics {
    static final int megaBytes = 0x100000;

    public static void logOperationStart(String operationName, Logger logger) {
        Statistics.logOperationStart(operationName, logger, (Priority)Level.INFO);
    }

    public static void logOperationStart(String operationName, Logger logger, Priority priority) {
        if (logger.isEnabledFor(priority)) {
            logger.log(priority, (Object)(operationName + " started"));
            ElkTimer timer = ElkTimer.getNamedTimer(operationName, 2);
            timer.reset();
            timer.start();
        }
    }

    public static void logOperationFinish(String operationName, Logger logger) {
        Statistics.logOperationFinish(operationName, logger, (Priority)Level.INFO);
    }

    public static void logOperationFinish(String operationName, Logger logger, Priority priority) {
        if (logger.isEnabledFor(priority)) {
            ElkTimer timer = ElkTimer.getNamedTimer(operationName, 2);
            timer.stop();
            logger.log(priority, (Object)(operationName + " finished in " + timer.getTotalWallTime() / 1000000L + " ms"));
        }
    }

    public static void logMemoryUsage(Logger logger) {
        Statistics.logMemoryUsage(logger, (Priority)Level.DEBUG);
    }

    public static void logMemoryUsage(Logger logger, Priority priority) {
        if (logger.isEnabledFor(priority)) {
            Runtime runtime = Runtime.getRuntime();
            logger.log(priority, (Object)("Memory (MB) Used/Total/Max: " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + "/" + runtime.totalMemory() / 0x100000L + "/" + runtime.maxMemory() / 0x100000L));
        }
    }
}

