/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class ConcurrentComputation<I, P extends InputProcessor<I>, F extends InputProcessorFactory<I, P>> {
    protected final F inputProcessorFactory;
    protected final int maxWorkers;
    protected final ComputationExecutor executor;
    protected final BlockingQueue<I> buffer;
    protected volatile boolean finishRequested;
    protected volatile boolean interrupted;
    protected final Runnable worker;

    public ConcurrentComputation(F inputProcessorFactory, ComputationExecutor executor, int maxWorkers, int bufferCapacity) {
        this.inputProcessorFactory = inputProcessorFactory;
        this.buffer = new ArrayBlockingQueue<I>(bufferCapacity);
        this.finishRequested = false;
        this.interrupted = false;
        this.worker = new Worker();
        this.executor = executor;
        this.maxWorkers = maxWorkers;
    }

    public ConcurrentComputation(F inputProcessorFactory, ComputationExecutor executor, int maxWorkers) {
        this(inputProcessorFactory, executor, maxWorkers, 512 + 32 * maxWorkers);
    }

    public synchronized boolean start() {
        this.finishRequested = false;
        this.interrupted = false;
        return this.executor.start(this.worker, this.maxWorkers);
    }

    public synchronized boolean submit(I input) throws InterruptedException {
        if (this.finishRequested) {
            return false;
        }
        this.buffer.put(input);
        return true;
    }

    public synchronized Iterable<I> interrupt() throws InterruptedException {
        if (!this.interrupted) {
            this.interrupted = true;
            this.executor.interrupt();
        }
        this.executor.waitDone();
        return this.buffer;
    }

    public void finish() throws InterruptedException {
        if (!this.finishRequested) {
            this.finishRequested = true;
            this.executor.interrupt();
        }
        this.executor.waitDone();
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public final void run() {
            inputProcessor = ConcurrentComputation.this.inputProcessorFactory.getEngine();
            try {
                while (true) {
                    if (ConcurrentComputation.this.interrupted) {
                        break;
                    }
                    try {
                        if (ConcurrentComputation.this.finishRequested) {
                            nextInput /* !! */  = ConcurrentComputation.this.buffer.poll();
                            if (nextInput /* !! */  == null) {
                                inputProcessor.process();
                                if (!ConcurrentComputation.this.interrupted && Thread.interrupted()) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            nextInput /* !! */  = ConcurrentComputation.this.buffer.take();
                        }
                        inputProcessor.submit(nextInput /* !! */ );
                        inputProcessor.process();
                        continue;
                    }
                    catch (InterruptedException e) {
                        if (ConcurrentComputation.this.interrupted) ** break;
                        continue;
                        Thread.currentThread().interrupt();
                    }
                    break;
                }
            }
            finally {
                inputProcessor.finish();
            }
        }
    }
}

