/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections.entryset;

import java.util.AbstractCollection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.semanticweb.elk.util.collections.entryset.Entry;

public class EntryHashSet<E extends Entry<E>>
extends AbstractCollection<E> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_UNDERLOAD_FACTOR = 0.15f;
    static final float DEFAULT_OVERLOAD_FACTOR = 0.75f;
    transient E[] buckets;
    transient int size;
    int minsize;
    int undersize;
    int oversize;
    final float overloadFactor;
    final float underloadFactor;
    volatile transient int modCount;

    public EntryHashSet(int initialCapacity, float underloadFactor, float overloadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (overloadFactor <= 0.0f || Float.isNaN(overloadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + overloadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.underloadFactor = overloadFactor;
        this.overloadFactor = overloadFactor;
        this.minsize = initialCapacity;
        this.undersize = (int)((float)capacity * underloadFactor);
        this.oversize = (int)((float)capacity * overloadFactor);
        this.buckets = new Entry[capacity];
        this.init();
    }

    public EntryHashSet(int initialCapacity) {
        this(initialCapacity, 0.15f, 0.75f);
    }

    public EntryHashSet() {
        this.underloadFactor = 0.15f;
        this.overloadFactor = 0.75f;
        this.undersize = 2;
        this.oversize = 12;
        this.buckets = (Entry[])new Object[16];
        this.init();
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return EntryHashSet.hash(h) & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    E mergeEntry(E entry) {
        int h = entry.hashCode();
        int i = EntryHashSet.indexFor(h, this.buckets.length);
        for (Object r = this.buckets[i]; r != null; r = (Entry)r.getNext()) {
            if (r.hashCode() != h || r != entry && !entry.equals(r)) continue;
            return r;
        }
        this.addEntry(entry, i);
        return entry;
    }

    void addEntry(E entry, int bucketIndex) {
        ++this.modCount;
        E e = this.buckets[bucketIndex];
        entry.setNext(e);
        this.buckets[bucketIndex] = entry;
        if (this.size++ >= this.oversize) {
            this.resize(2 * this.buckets.length);
        }
    }

    E getEntry(Object o) {
        int h = o.hashCode();
        int i = EntryHashSet.indexFor(h, this.buckets.length);
        for (Object r = this.buckets[i]; r != null; r = (Entry)r.getNext()) {
            if (r.hashCode() != h || r != o && !o.equals(r)) continue;
            return r;
        }
        return null;
    }

    final E removeEntry(Object o) {
        E prev;
        int h = o.hashCode();
        int i = EntryHashSet.indexFor(h, this.buckets.length);
        Object r = prev = this.buckets[i];
        while (r != null) {
            Entry next = (Entry)r.getNext();
            if (r.hashCode() == h && (r == o || o.equals(r))) {
                ++this.modCount;
                if (prev == r) {
                    this.buckets[i] = next;
                } else {
                    prev.setNext((Entry)next);
                }
                if (this.buckets.length >= 2 * this.minsize && this.size-- <= this.undersize) {
                    this.resize(this.buckets.length / 2);
                }
                return r;
            }
            prev = r;
            r = next;
        }
        return r;
    }

    void resize(int newCapacity) {
        E[] oldTable = this.buckets;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.oversize = Integer.MAX_VALUE;
            this.oversize = (int)((float)newCapacity * this.overloadFactor);
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.buckets = newTable;
        this.undersize = (int)((float)newCapacity * this.underloadFactor);
        this.oversize = (int)((float)newCapacity * this.overloadFactor);
    }

    void transfer(E[] newArray) {
        E[] src = this.buckets;
        int newCapacity = newArray.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Object e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = (Entry)e.getNext();
                int i = EntryHashSet.indexFor(e.hashCode(), newCapacity);
                e.setNext(newArray[i]);
                newArray[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        E[] tab = this.buckets;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    Iterator<E> entryIterator() {
        return new EntryIterator();
    }

    @Override
    public Iterator<E> iterator() {
        return new EntryIterator();
    }

    private class EntryIterator
    implements Iterator<E> {
        E next;
        int expectedModCount;
        int index;
        E current;

        EntryIterator() {
            this.expectedModCount = EntryHashSet.this.modCount;
            if (EntryHashSet.this.size > 0) {
                E[] t = EntryHashSet.this.buckets;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final E next() {
            if (EntryHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = (Entry)e.getNext();
            if (this.next == null) {
                E[] t = EntryHashSet.this.buckets;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (EntryHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            EntryHashSet.this.removeEntry(this.current);
            this.current = null;
            this.expectedModCount = EntryHashSet.this.modCount;
        }
    }
}

