/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Operations {
    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        return Operations.concat(Arrays.asList(a, b));
    }

    public static <T> Iterable<T> singleton(final T element) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    boolean hasNext = true;

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public T next() {
                        this.hasNext = false;
                        return element;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> concat(final Iterable<? extends Iterable<? extends T>> input) {
        assert (input != null);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends Iterable<? extends T>> outer;
                    Iterator<? extends T> inner;
                    boolean hasNext;
                    {
                        this.outer = input.iterator();
                        this.hasNext = this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public T next() {
                        if (this.hasNext) {
                            Object result = this.inner.next();
                            this.hasNext = this.advance();
                            return result;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    boolean advance() {
                        while (true) {
                            if (this.inner != null && this.inner.hasNext()) {
                                return true;
                            }
                            if (!this.outer.hasNext()) break;
                            this.inner = this.outer.next().iterator();
                        }
                        return false;
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> input, final Condition<? super T> condition) {
        assert (input != null);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<T> i;
                    T next;
                    boolean hasNext;
                    {
                        this.i = input.iterator();
                        this.hasNext = this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public T next() {
                        if (this.hasNext) {
                            Object result = this.next;
                            this.hasNext = this.advance();
                            return result;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    boolean advance() {
                        while (this.i.hasNext()) {
                            this.next = this.i.next();
                            if (!condition.holds(this.next)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }

    public static <T, S> Iterable<T> filter(Iterable<S> input, final Class<T> type) {
        return Operations.filter(input, new Condition<S>(){

            @Override
            public boolean holds(S element) {
                return type.isInstance(element);
            }
        });
    }

    public static <T> Set<T> filter(final Set<T> input, final Condition<? super T> condition, final int size) {
        return new Set<T>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean isEmpty() {
                return size == 0;
            }

            @Override
            public boolean contains(Object o) {
                if (!input.contains(o)) {
                    return false;
                }
                Object elem = null;
                try {
                    elem = o;
                }
                catch (ClassCastException cce) {
                    return false;
                }
                return condition.holds(elem);
            }

            @Override
            public Iterator<T> iterator() {
                return Operations.filter(input, condition).iterator();
            }

            @Override
            public Object[] toArray() {
                Object[] result = new Object[size];
                int i = 0;
                for (Object o : Operations.filter(input, condition)) {
                    result[i++] = o;
                }
                return result;
            }

            @Override
            public <S> S[] toArray(S[] a) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(T e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (!this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static interface Condition<T> {
        public boolean holds(T var1);
    }
}

