/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class LazySetIntersection<E>
extends AbstractSet<E> {
    final Set<E> firstSet;
    final Set<E> secondSet;

    public LazySetIntersection(Set<E> firstSet, Set<E> secondSet) {
        this.firstSet = firstSet;
        this.secondSet = secondSet;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.firstSet.size() < this.secondSet.size()) {
            return new SetIntersectionIterator<E>(this.firstSet, this.secondSet);
        }
        return new SetIntersectionIterator<E>(this.secondSet, this.firstSet);
    }

    @Override
    public boolean contains(Object o) {
        return this.firstSet.contains(o) && this.secondSet.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return Math.min(this.firstSet.size(), this.secondSet.size());
    }

    static class SetIntersectionIterator<E>
    implements Iterator<E> {
        final Iterator<E> elementIterator;
        final Set<E> elementChecker;
        boolean hasNext;
        E next;

        SetIntersectionIterator(Set<E> iteratingSet, Set<E> checkingSet) {
            this.elementIterator = iteratingSet.iterator();
            this.elementChecker = checkingSet;
            this.seekNext();
        }

        void seekNext() {
            this.hasNext = false;
            while (!this.hasNext && this.elementIterator.hasNext()) {
                this.next = this.elementIterator.next();
                if (!this.elementChecker.contains(this.next)) continue;
                this.hasNext = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            E result = this.next;
            this.seekNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

