/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayHashSet<E>
implements Set<E> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    protected transient E[] data;
    protected transient int size;
    int threshold;

    public ArrayHashSet(int initialCapacity) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.data = new Object[capacity];
        this.size = 0;
        this.threshold = ArrayHashSet.computeThreshold(capacity);
    }

    public ArrayHashSet() {
        int capacity = 16;
        this.data = new Object[capacity];
        this.size = 0;
        this.threshold = ArrayHashSet.computeThreshold(capacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    static int computeThreshold(int capacity) {
        if (capacity > 128) {
            return 3 * capacity / 4;
        }
        return capacity;
    }

    static int getIndex(Object o, int length) {
        return o.hashCode() & length - 1;
    }

    @Override
    public boolean contains(Object o) {
        int i;
        if (o == null) {
            throw new NullPointerException();
        }
        E[] data = this.data;
        int j = i = ArrayHashSet.getIndex(o, data.length);
        do {
            E probe;
            if ((probe = data[i]) == null) {
                return false;
            }
            if (o.equals(probe)) {
                return true;
            }
            if (i == 0) {
                i = data.length - 1;
                continue;
            }
            --i;
        } while (i != j);
        return false;
    }

    private boolean addElement(E[] data, E e) {
        int i = ArrayHashSet.getIndex(e, data.length);
        while (true) {
            E probe;
            if ((probe = data[i]) == null) {
                data[i] = e;
                return true;
            }
            if (e.equals(probe)) {
                return false;
            }
            if (i == 0) {
                i = data.length - 1;
                continue;
            }
            --i;
        }
    }

    public void resize() {
        int oldCapacity = this.data.length;
        if (oldCapacity == 0x40000000) {
            throw new IllegalArgumentException("The set cannot grow beyond the capacity: 1073741824");
        }
        E[] oldData = this.data;
        int newCapacity = oldCapacity << 1;
        Object[] newData = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            E e = oldData[i];
            if (e == null) continue;
            this.addElement(newData, e);
        }
        this.data = newData;
        this.threshold = ArrayHashSet.computeThreshold(newCapacity);
    }

    @Override
    public boolean add(E e) {
        boolean result;
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.size == this.threshold) {
            this.resize();
        }
        if (result = this.addElement(this.data, e)) {
            ++this.size;
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        for (E element : this) {
            result[i++] = element;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean change = false;
        for (E element : c) {
            change = this.add(element) || change;
        }
        return change;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            this.data[i] = null;
        }
        this.size = 0;
    }

    private class ElementIterator
    implements Iterator<E> {
        final E[] dataSnapshot;
        final int expectedSize;
        int cursor;
        E nextElement;

        ElementIterator() {
            this.expectedSize = ArrayHashSet.this.size;
            this.dataSnapshot = ArrayHashSet.this.data;
            this.cursor = 0;
            this.seekNext();
        }

        void seekNext() {
            this.nextElement = null;
            while (this.cursor < this.dataSnapshot.length && (this.nextElement = this.dataSnapshot[this.cursor]) == null) {
                ++this.cursor;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            if (this.expectedSize != ArrayHashSet.this.size) {
                throw new ConcurrentModificationException();
            }
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
            Object result = this.nextElement;
            ++this.cursor;
            this.seekNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

