/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.hashing;

import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.hashing.NodeHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.hashing.HashGenerator;
import org.semanticweb.elk.util.hashing.Hasher;

public class TypeNodeHasher
implements Hasher<TypeNode<? extends ElkEntity, ? extends ElkEntity>> {
    public static TypeNodeHasher INSTANCE = new TypeNodeHasher();

    private TypeNodeHasher() {
    }

    @Override
    public int hash(TypeNode<? extends ElkEntity, ? extends ElkEntity> node) {
        int memberHash = NodeHasher.INSTANCE.hash((Node<? extends ElkEntity>)node);
        int subClassHash = "subClassOf".hashCode();
        for (TypeNode<? extends ElkEntity, ? extends ElkEntity> o : node.getDirectSubNodes()) {
            subClassHash = HashGenerator.combineMultisetHash(false, subClassHash, NodeHasher.INSTANCE.hash((Node<? extends ElkEntity>)o));
        }
        int superClassHash = "superClassOf".hashCode();
        for (TypeNode<? extends ElkEntity, ? extends ElkEntity> o : node.getDirectSuperNodes()) {
            superClassHash = HashGenerator.combineMultisetHash(false, superClassHash, NodeHasher.INSTANCE.hash((Node<? extends ElkEntity>)o));
        }
        int instanceHash = "instanceOf".hashCode();
        for (InstanceNode<? extends ElkEntity, ? extends ElkEntity> o : node.getDirectInstanceNodes()) {
            instanceHash = HashGenerator.combineMultisetHash(false, instanceHash, NodeHasher.INSTANCE.hash((Node<? extends ElkEntity>)o));
        }
        return HashGenerator.combineListHash(memberHash, subClassHash, superClassHash, instanceHash);
    }
}

