/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.hashing;

import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.hashing.NodeHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.util.hashing.HashGenerator;
import org.semanticweb.elk.util.hashing.Hasher;

public class TaxonomyNodeHasher
implements Hasher<TaxonomyNode<? extends ElkEntity>> {
    public static TaxonomyNodeHasher INSTANCE = new TaxonomyNodeHasher();

    private TaxonomyNodeHasher() {
    }

    @Override
    public int hash(TaxonomyNode<? extends ElkEntity> node) {
        int memberHash = NodeHasher.INSTANCE.hash((Node<? extends ElkEntity>)node);
        int subClassHash = "subClassOf".hashCode();
        for (TaxonomyNode<? extends ElkEntity> o : node.getDirectSubNodes()) {
            subClassHash = HashGenerator.combineMultisetHash(false, subClassHash, NodeHasher.INSTANCE.hash((Node<? extends ElkEntity>)o));
        }
        int superClassHash = "superClassOf".hashCode();
        for (TaxonomyNode<? extends ElkEntity> o : node.getDirectSuperNodes()) {
            superClassHash = HashGenerator.combineMultisetHash(false, superClassHash, NodeHasher.INSTANCE.hash((Node<? extends ElkEntity>)o));
        }
        return HashGenerator.combineListHash(memberHash, subClassHash, superClassHash);
    }
}

