/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.semanticweb.elk.owl.AbstractElkAxiomVisitor;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.predefined.PredefinedElkIri;
import org.semanticweb.elk.owl.visitors.AbstractElkEntityVisitor;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.IndividualNode;
import org.semanticweb.elk.reasoner.taxonomy.NonBottomClassNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;

public class TaxonomyLoader {
    public static InstanceTaxonomy<ElkClass, ElkNamedIndividual> load(Owl2Parser parser) throws IOException, Owl2ParseException {
        ConcurrentTaxonomy taxonomy = new ConcurrentTaxonomy();
        TaxonomyInserter listener = new TaxonomyInserter(taxonomy);
        parser.accept(listener);
        PredefinedElkClass thing = PredefinedElkClass.OWL_THING;
        if (taxonomy.unsatisfiableClasses.contains(thing)) {
            return taxonomy;
        }
        NonBottomClassNode topNode = taxonomy.getCreateClassNode(Collections.singleton(thing));
        listener.createNodes = true;
        TaxonomyLoader.process(listener, listener.classDeclarations);
        TaxonomyLoader.process(listener, listener.subClassOfAxioms);
        TaxonomyLoader.process(listener, listener.individualDeclarations);
        TaxonomyNode<ElkClass> botNode = taxonomy.getNode(PredefinedElkClass.OWL_NOTHING);
        for (TaxonomyNode<ElkClass> taxonomyNode : taxonomy.getNodes()) {
            if (taxonomyNode == topNode || taxonomyNode == botNode) continue;
            NonBottomClassNode nbNode = (NonBottomClassNode)taxonomyNode;
            if (!taxonomyNode.getDirectSuperNodes().isEmpty()) continue;
            nbNode.addDirectSuperNode(topNode);
            topNode.addDirectSubNode(nbNode);
        }
        return taxonomy;
    }

    private static void process(TaxonomyInserter inserter, List<ElkAxiom> axioms) {
        for (ElkAxiom decl : axioms) {
            decl.accept(inserter);
        }
    }

    static class TaxonomyInserter
    extends AbstractElkAxiomVisitor<Void>
    implements Owl2ParserAxiomProcessor {
        boolean createNodes = false;
        final ConcurrentTaxonomy taxonomy;
        final List<ElkAxiom> subClassOfAxioms = new ArrayList<ElkAxiom>();
        final List<ElkAxiom> classDeclarations = new ArrayList<ElkAxiom>();
        final List<ElkAxiom> individualDeclarations = new ArrayList<ElkAxiom>();

        TaxonomyInserter(ConcurrentTaxonomy taxonomy) {
            this.taxonomy = taxonomy;
        }

        @Override
        public Void visit(ElkEquivalentClassesAxiom elkEquivalentClassesAxiom) {
            HashSet<ElkClass> classes = new HashSet<ElkClass>();
            boolean nothing = false;
            for (ElkClassExpression elkClassExpression : elkEquivalentClassesAxiom.getClassExpressions()) {
                if (!(elkClassExpression instanceof ElkClass)) continue;
                ElkClass clazz = (ElkClass)elkClassExpression;
                if (clazz.getIri().equals(PredefinedElkIri.OWL_NOTHING.get())) {
                    nothing = true;
                    continue;
                }
                classes.add(clazz);
            }
            if (!nothing) {
                this.taxonomy.getCreateClassNode(classes);
            } else {
                this.taxonomy.unsatisfiableClasses.addAll(classes);
            }
            return null;
        }

        @Override
        public Void visit(ElkSubClassOfAxiom elkSubClassOfAxiom) {
            ElkClassExpression subCE = elkSubClassOfAxiom.getSubClassExpression();
            ElkClassExpression superCE = elkSubClassOfAxiom.getSuperClassExpression();
            if (subCE instanceof ElkClass && superCE instanceof ElkClass) {
                ElkClass subClass = (ElkClass)subCE;
                ElkClass superClass = (ElkClass)superCE;
                NonBottomClassNode subNode = this.taxonomy.getNode(subClass);
                NonBottomClassNode superNode = this.taxonomy.getNode(superClass);
                NonBottomClassNode subNonBot = null;
                NonBottomClassNode superNonBot = null;
                if (!(subNode != null && superNode != null || this.createNodes)) {
                    this.subClassOfAxioms.add(elkSubClassOfAxiom);
                } else {
                    subNonBot = subNode == null ? this.taxonomy.getCreateClassNode(Collections.singleton(subClass)) : subNode;
                    superNonBot = superNode == null ? this.taxonomy.getCreateClassNode(Collections.singleton(superClass)) : superNode;
                    subNonBot.addDirectSuperNode(superNonBot);
                    superNonBot.addDirectSubNode(subNonBot);
                }
            }
            return null;
        }

        @Override
        public Void visit(final ElkDeclarationAxiom elkDeclarationAxiom) {
            ElkEntity entity = elkDeclarationAxiom.getEntity();
            entity.accept(new AbstractElkEntityVisitor<Object>(){

                @Override
                public Object visit(ElkClass elkClass) {
                    if (TaxonomyInserter.this.createNodes) {
                        if (TaxonomyInserter.this.taxonomy.getNode(elkClass) == null) {
                            TaxonomyInserter.this.taxonomy.getCreateClassNode(Collections.singleton(elkClass));
                        }
                    } else {
                        TaxonomyInserter.this.classDeclarations.add(elkDeclarationAxiom);
                    }
                    return null;
                }

                @Override
                public Object visit(ElkNamedIndividual elkNamedIndividual) {
                    if (TaxonomyInserter.this.createNodes) {
                        if (TaxonomyInserter.this.taxonomy.getInstanceNode(elkNamedIndividual) == null) {
                            NonBottomClassNode top = (NonBottomClassNode)TaxonomyInserter.this.taxonomy.getTopNode();
                            IndividualNode indNode = TaxonomyInserter.this.taxonomy.getCreateIndividualNode(Collections.singleton(elkNamedIndividual));
                            indNode.addDirectTypeNode(top);
                            top.addDirectInstanceNode(indNode);
                        }
                    } else {
                        TaxonomyInserter.this.individualDeclarations.add(elkDeclarationAxiom);
                    }
                    return null;
                }
            });
            return null;
        }

        @Override
        public Void visit(ElkClassAssertionAxiom elkClassAssertionAxiom) {
            if (elkClassAssertionAxiom.getClassExpression() instanceof ElkClass && elkClassAssertionAxiom.getIndividual() instanceof ElkNamedIndividual) {
                ElkClass type = (ElkClass)elkClassAssertionAxiom.getClassExpression();
                ElkNamedIndividual individual = (ElkNamedIndividual)elkClassAssertionAxiom.getIndividual();
                TaxonomyNode<ElkClass> typeNode = this.taxonomy.getNode(type);
                if (typeNode == null && !this.createNodes) {
                    this.subClassOfAxioms.add(elkClassAssertionAxiom);
                } else {
                    IndividualNode indNode = (IndividualNode)this.taxonomy.getInstanceNode(individual);
                    if (indNode == null) {
                        indNode = this.taxonomy.getCreateIndividualNode(Collections.singleton(individual));
                    }
                    if (typeNode instanceof NonBottomClassNode) {
                        ((NonBottomClassNode)typeNode).addDirectInstanceNode(indNode);
                        indNode.addDirectTypeNode((NonBottomClassNode)typeNode);
                    }
                }
            }
            return null;
        }

        @Override
        public void visit(ElkAxiom elkAxiom) {
            elkAxiom.accept(this);
        }

        @Override
        public void visit(ElkPrefix elkPrefix) throws Owl2ParseException {
        }
    }
}

