/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.hashing.HashGenerator;

public class NonBottomClassNode
implements TypeNode<ElkClass, ElkNamedIndividual> {
    private static final Logger LOGGER_ = Logger.getLogger(NonBottomClassNode.class);
    private final ConcurrentTaxonomy taxonomy_;
    private final List<ElkClass> members_;
    private final Set<TypeNode<ElkClass, ElkNamedIndividual>> directSuperNodes_;
    private final Set<TypeNode<ElkClass, ElkNamedIndividual>> directSubNodes_;
    private final Set<InstanceNode<ElkClass, ElkNamedIndividual>> directInstanceNodes_;
    private final int hashCode_ = HashGenerator.generateNextHashCode();

    protected NonBottomClassNode(ConcurrentTaxonomy taxonomy, Collection<ElkClass> members) {
        this.taxonomy_ = taxonomy;
        this.members_ = new ArrayList<ElkClass>(members);
        this.directSubNodes_ = new ArrayHashSet<TypeNode<ElkClass, ElkNamedIndividual>>();
        this.directSuperNodes_ = new ArrayHashSet<TypeNode<ElkClass, ElkNamedIndividual>>();
        this.directInstanceNodes_ = new ArrayHashSet<InstanceNode<ElkClass, ElkNamedIndividual>>();
        Collections.sort(this.members_, Comparators.ELK_CLASS_COMPARATOR);
    }

    void addDirectSuperNode(NonBottomClassNode superNode) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": new direct super-node " + superNode));
        }
        this.directSuperNodes_.add(superNode);
    }

    void addDirectSubNode(NonBottomClassNode subNode) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": new direct sub-node " + subNode));
        }
        if (this.directSubNodes_.isEmpty()) {
            this.taxonomy_.countNodesWithSubClasses.incrementAndGet();
        }
        this.directSubNodes_.add(subNode);
    }

    void addDirectInstanceNode(InstanceNode<ElkClass, ElkNamedIndividual> instanceNode) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": new direct instance-node " + instanceNode));
        }
        this.directInstanceNodes_.add(instanceNode);
    }

    @Override
    public Set<ElkClass> getMembers() {
        return new AbstractSet<ElkClass>(){

            @Override
            public boolean contains(Object arg) {
                if (arg instanceof ElkClass) {
                    return Collections.binarySearch(NonBottomClassNode.this.members_, (ElkClass)arg, Comparators.ELK_CLASS_COMPARATOR) >= 0;
                }
                return false;
            }

            @Override
            public boolean isEmpty() {
                return NonBottomClassNode.this.members_.isEmpty();
            }

            @Override
            public Iterator<ElkClass> iterator() {
                return NonBottomClassNode.this.members_.iterator();
            }

            @Override
            public int size() {
                return NonBottomClassNode.this.members_.size();
            }
        };
    }

    @Override
    public ElkClass getCanonicalMember() {
        return this.members_.get(0);
    }

    @Override
    public Set<TypeNode<ElkClass, ElkNamedIndividual>> getDirectSuperNodes() {
        return Collections.unmodifiableSet(this.directSuperNodes_);
    }

    @Override
    public Set<TypeNode<ElkClass, ElkNamedIndividual>> getAllSuperNodes() {
        ArrayHashSet<TypeNode> result = new ArrayHashSet<TypeNode>(this.directSuperNodes_.size());
        LinkedList todo = new LinkedList();
        todo.addAll(this.directSuperNodes_);
        while (!todo.isEmpty()) {
            TypeNode next = (TypeNode)todo.poll();
            if (!result.add(next)) continue;
            for (TypeNode nextSuperNode : next.getDirectSuperNodes()) {
                todo.add(nextSuperNode);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<TypeNode<ElkClass, ElkNamedIndividual>> getDirectSubNodes() {
        if (!this.directSubNodes_.isEmpty()) {
            return Collections.unmodifiableSet(this.directSubNodes_);
        }
        ArrayHashSet<ConcurrentTaxonomy.BottomClassNode> result = new ArrayHashSet<ConcurrentTaxonomy.BottomClassNode>(1);
        result.add(this.taxonomy_.bottomClassNode);
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<TypeNode<ElkClass, ElkNamedIndividual>> getAllSubNodes() {
        ArrayHashSet<TypeNode> result;
        if (!this.directSubNodes_.isEmpty()) {
            result = new ArrayHashSet(this.directSubNodes_.size());
            LinkedList todo = new LinkedList();
            todo.addAll(this.directSubNodes_);
            while (!todo.isEmpty()) {
                TypeNode next = (TypeNode)todo.poll();
                if (!result.add(next)) continue;
                for (TypeNode nextSubNode : next.getDirectSubNodes()) {
                    todo.add(nextSubNode);
                }
            }
        } else {
            result = new ArrayHashSet<TypeNode>(1);
            result.add(this.taxonomy_.bottomClassNode);
        }
        return Collections.unmodifiableSet(result);
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    @Override
    public InstanceTaxonomy<ElkClass, ElkNamedIndividual> getTaxonomy() {
        return this.taxonomy_;
    }

    public String toString() {
        return OwlFunctionalStylePrinter.toString(this.getCanonicalMember());
    }

    @Override
    public Set<InstanceNode<ElkClass, ElkNamedIndividual>> getDirectInstanceNodes() {
        return Collections.unmodifiableSet(this.directInstanceNodes_);
    }

    @Override
    public Set<InstanceNode<ElkClass, ElkNamedIndividual>> getAllInstanceNodes() {
        Set<InstanceNode<ElkClass, ElkNamedIndividual>> result;
        if (!this.directSubNodes_.isEmpty()) {
            result = new ArrayHashSet<InstanceNode<ElkClass, ElkNamedIndividual>>(this.directInstanceNodes_.size());
            LinkedList todo = new LinkedList();
            todo.add(this);
            while (!todo.isEmpty()) {
                TypeNode next = (TypeNode)todo.poll();
                result.addAll(next.getDirectInstanceNodes());
                for (TypeNode nextSubNode : next.getDirectSubNodes()) {
                    todo.add(nextSubNode);
                }
            }
        } else {
            result = this.getDirectInstanceNodes();
        }
        return Collections.unmodifiableSet(result);
    }
}

