/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collections;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionFactory;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionJob;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionListener;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutput;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalent;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputUnsatisfiable;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputVisitor;
import org.semanticweb.elk.reasoner.taxonomy.IndividualClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.IndividualNode;
import org.semanticweb.elk.reasoner.taxonomy.NonBottomClassNode;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class InstanceTaxonomyComputationFactory
implements InputProcessorFactory<IndexedIndividual, Engine> {
    private final IndividualClassTaxonomy taxonomy_;
    private final TransitiveReductionFactory<IndexedIndividual, TransitiveReductionJob<IndexedIndividual>> transitiveReductionShared_;
    private final TransitiveReductionOutputProcessor outputProcessor_;
    private final NonBottomClassNode topNode_;

    public InstanceTaxonomyComputationFactory(OntologyIndex ontologyIndex, int maxWorkers, IndividualClassTaxonomy partialTaxonomy) {
        this.taxonomy_ = partialTaxonomy;
        this.transitiveReductionShared_ = new TransitiveReductionFactory(ontologyIndex, maxWorkers, new ThisTransitiveReductionListener());
        this.outputProcessor_ = new TransitiveReductionOutputProcessor();
        this.topNode_ = (NonBottomClassNode)partialTaxonomy.getTopNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assignDirectTypeNode(IndividualNode instanceNode, NonBottomClassNode typeNode) {
        instanceNode.addDirectTypeNode(typeNode);
        NonBottomClassNode nonBottomClassNode = typeNode;
        synchronized (nonBottomClassNode) {
            typeNode.addDirectInstanceNode(instanceNode);
        }
    }

    public IndividualClassTaxonomy getTaxonomy() {
        return this.taxonomy_;
    }

    public void printStatistics() {
        this.transitiveReductionShared_.printStatistics();
    }

    @Override
    public Engine getEngine() {
        return new Engine();
    }

    public class Engine
    implements InputProcessor<IndexedIndividual> {
        protected final TransitiveReductionFactory.Engine transitiveReductionEngine;

        private Engine() {
            this.transitiveReductionEngine = InstanceTaxonomyComputationFactory.this.transitiveReductionShared_.getEngine();
        }

        @Override
        public final void submit(IndexedIndividual job) {
            this.transitiveReductionEngine.submit(new TransitiveReductionJob<IndexedIndividual>(job));
        }

        @Override
        public final void process() throws InterruptedException {
            this.transitiveReductionEngine.process();
        }

        @Override
        public void finish() {
            this.transitiveReductionEngine.finish();
        }
    }

    private class TransitiveReductionOutputProcessor
    implements TransitiveReductionOutputVisitor<IndexedIndividual> {
        private TransitiveReductionOutputProcessor() {
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalentDirect<IndexedIndividual> output) {
            IndividualNode node = InstanceTaxonomyComputationFactory.this.taxonomy_.getCreateIndividualNode(Collections.singleton(((IndexedIndividual)output.getRoot()).getElkNamedIndividual()));
            for (TransitiveReductionOutputEquivalent<IndexedClass> directSuperEquivalent : output.getDirectSuperClasses()) {
                NonBottomClassNode superNode = InstanceTaxonomyComputationFactory.this.taxonomy_.getCreateClassNode(directSuperEquivalent.getEquivalent());
                InstanceTaxonomyComputationFactory.assignDirectTypeNode(node, superNode);
            }
            if (node.getDirectTypeNodes().isEmpty()) {
                InstanceTaxonomyComputationFactory.assignDirectTypeNode(node, InstanceTaxonomyComputationFactory.this.topNode_);
            }
        }

        @Override
        public void visit(TransitiveReductionOutputUnsatisfiable<IndexedIndividual> output) {
            throw new IllegalArgumentException();
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalent<IndexedIndividual> output) {
            throw new IllegalArgumentException();
        }
    }

    private class ThisTransitiveReductionListener
    implements TransitiveReductionListener<TransitiveReductionJob<IndexedIndividual>, TransitiveReductionFactory.Engine> {
        private ThisTransitiveReductionListener() {
        }

        @Override
        public void notifyFinished(TransitiveReductionJob<IndexedIndividual> job) throws InterruptedException {
            ((TransitiveReductionOutput)job.getOutput()).accept(InstanceTaxonomyComputationFactory.this.outputProcessor_);
        }
    }
}

