/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collections;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.Loader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;

public class OntologyLoadingStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(OntologyLoadingStage.class);

    public OntologyLoadingStage(AbstractReasonerState reasoner) {
        super(reasoner);
    }

    @Override
    public String getName() {
        return "Loading of Axioms";
    }

    @Override
    public boolean done() {
        return this.reasoner.doneLoading;
    }

    @Override
    public Iterable<ReasonerStage> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void execute() throws ElkException {
        this.initComputation();
        Loader ontologyLoader = this.reasoner.getOntologyLoader();
        if (ontologyLoader == null) {
            LOGGER_.warn((Object)"Ontology loader is not registered. No axioms will be loaded!");
        } else {
            do {
                ontologyLoader.load();
            } while (this.interrupted());
        }
        this.reasoner.doneLoading = true;
    }

    @Override
    public void printInfo() {
    }
}

