/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.saturation.properties.ObjectPropertyHierarchyComputation;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ChangesLoadingStage;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.OntologyLoadingStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;

public class ObjectPropertyHierarchyComputationStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(ObjectPropertyHierarchyComputationStage.class);
    private ObjectPropertyHierarchyComputation computation;
    private final int workerNo;

    public ObjectPropertyHierarchyComputationStage(AbstractReasonerState reasoner) {
        super(reasoner);
        this.workerNo = reasoner.getNumberOfWorkers();
        this.progressMonitor = reasoner.getProgressMonitor();
    }

    @Override
    public String getName() {
        return "Object Property Hierarchy Computation";
    }

    @Override
    public boolean done() {
        return this.reasoner.doneObjectPropertyHierarchyComputation;
    }

    public List<ReasonerStage> getDependencies() {
        return Arrays.asList(new OntologyLoadingStage(this.reasoner), new ChangesLoadingStage(this.reasoner));
    }

    @Override
    public void execute() throws ElkInterruptedException {
        if (this.computation == null) {
            this.initComputation();
        }
        do {
            this.computation.process();
        } while (this.interrupted());
        this.reasoner.doneObjectPropertyHierarchyComputation = true;
    }

    @Override
    void initComputation() {
        super.initComputation();
        this.computation = new ObjectPropertyHierarchyComputation(this.reasoner.getProcessExecutor(), this.workerNo, this.progressMonitor, this.reasoner.ontologyIndex);
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)(this.getName() + " using " + this.workerNo + " workers"));
        }
    }

    @Override
    public void printInfo() {
    }
}

