/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.saturation.properties.ObjectPropertyCompositionsPrecomputation;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ObjectPropertyHierarchyComputationStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;

public class ObjectPropertyCompositionsPrecomputationStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(ObjectPropertyCompositionsPrecomputationStage.class);
    private ObjectPropertyCompositionsPrecomputation computation;

    public ObjectPropertyCompositionsPrecomputationStage(AbstractReasonerState reasoner) {
        super(reasoner);
    }

    @Override
    public String getName() {
        return "Object Property Compositions Precomputation";
    }

    @Override
    public boolean done() {
        return this.reasoner.doneObjectPropertyCompositionsPrecomputation;
    }

    public List<ReasonerStage> getDependencies() {
        return Arrays.asList(new ObjectPropertyHierarchyComputationStage(this.reasoner));
    }

    @Override
    public void execute() throws ElkInterruptedException {
        if (this.computation == null) {
            this.initComputation();
        }
        do {
            this.computation.process();
        } while (this.interrupted());
        this.reasoner.doneObjectPropertyCompositionsPrecomputation = true;
    }

    @Override
    void initComputation() {
        super.initComputation();
        this.computation = new ObjectPropertyCompositionsPrecomputation(this.reasoner.getProcessExecutor(), this.workerNo, this.progressMonitor, this.reasoner.ontologyIndex);
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)(this.getName() + " using " + this.workerNo + " workers"));
        }
    }

    @Override
    public void printInfo() {
    }
}

