/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;
import org.semanticweb.elk.util.logging.Statistics;

public class LoggingStageExecutor
extends SimpleInterrupter
implements ReasonerStageExecutor {
    private static final Logger LOGGER_ = Logger.getLogger(LoggingStageExecutor.class);

    @Override
    public void complete(ReasonerStage stage) throws ElkException {
        if (!stage.done()) {
            if (LOGGER_.isDebugEnabled()) {
                LOGGER_.debug((Object)(stage.getName() + " stage:"));
            }
            for (ReasonerStage dependentStage : stage.getDependencies()) {
                this.complete(dependentStage);
            }
            Statistics.logOperationStart(stage.getName(), LOGGER_);
            this.registerCurrentThreadToInterrupt();
            try {
                stage.execute();
            }
            catch (ElkInterruptedException e) {
                LOGGER_.debug((Object)(stage.getName() + " was interrupted."));
                throw e;
            }
            finally {
                this.clearThreadToInterrupt();
                Statistics.logOperationFinish(stage.getName(), LOGGER_);
                Statistics.logMemoryUsage(LOGGER_);
                stage.printInfo();
            }
            if (LOGGER_.isDebugEnabled()) {
                LOGGER_.debug((Object)(stage.getName() + " done."));
            }
        }
    }
}

