/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;

class ContextInitializationStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(ContextInitializationStage.class);
    private int deletedContexts;
    private int maxContexts;
    private Iterator<IndexedClassExpression> todo = null;

    public ContextInitializationStage(AbstractReasonerState reasoner) {
        super(reasoner);
    }

    @Override
    public String getName() {
        return "Context Initialization";
    }

    @Override
    public boolean done() {
        return this.reasoner.doneContextReset;
    }

    public List<ReasonerStage> getDependencies() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ElkInterruptedException {
        if (this.todo == null) {
            this.initComputation();
        }
        try {
            this.progressMonitor.start(this.getName());
            while (this.todo.hasNext()) {
                IndexedClassExpression ice = this.todo.next();
                ice.resetContext();
                ++this.deletedContexts;
                this.progressMonitor.report(this.deletedContexts, this.maxContexts);
                if (!this.interrupted()) continue;
            }
        }
        finally {
            this.progressMonitor.finish();
        }
        this.reasoner.doneContextReset = true;
    }

    @Override
    void initComputation() {
        super.initComputation();
        this.todo = this.reasoner.ontologyIndex.getIndexedClassExpressions().iterator();
        this.maxContexts = this.reasoner.ontologyIndex.getIndexedClassExpressions().size();
        this.deletedContexts = 0;
    }

    @Override
    public void printInfo() {
        if (this.deletedContexts > 0 && LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)("Contexts deleted:" + this.deletedContexts));
        }
    }
}

