/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ConsistencyCheckingStage;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.reasoner.taxonomy.ClassTaxonomyComputation;

class ClassTaxonomyComputationStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(ClassTaxonomyComputationStage.class);
    private ClassTaxonomyComputation computation = null;

    public ClassTaxonomyComputationStage(AbstractReasonerState reasoner) {
        super(reasoner);
    }

    @Override
    public String getName() {
        return "Class Taxonomy Computation";
    }

    @Override
    public boolean done() {
        return this.reasoner.doneClassTaxonomy;
    }

    public List<ReasonerStage> getDependencies() {
        return Arrays.asList(new ConsistencyCheckingStage(this.reasoner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ElkInterruptedException {
        if (this.computation == null) {
            this.initComputation();
        }
        this.progressMonitor.start(this.getName());
        try {
            do {
                this.computation.process();
            } while (this.interrupted());
        }
        finally {
            this.progressMonitor.finish();
        }
        this.reasoner.taxonomy = this.computation.getTaxonomy();
        this.reasoner.doneClassTaxonomy = true;
    }

    @Override
    void initComputation() {
        super.initComputation();
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)(this.getName() + " using " + this.workerNo + " workers"));
        }
        this.computation = new ClassTaxonomyComputation(this.reasoner.ontologyIndex.getIndexedClasses(), this.reasoner.getProcessExecutor(), this.workerNo, this.progressMonitor, this.reasoner.ontologyIndex);
    }

    @Override
    public void printInfo() {
        if (this.computation != null) {
            this.computation.printStatistics();
        }
    }
}

