/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;

abstract class AbstractReasonerStage
implements ReasonerStage {
    final AbstractReasonerState reasoner;
    int workerNo;
    ProgressMonitor progressMonitor;

    public AbstractReasonerStage(AbstractReasonerState reasoner) {
        this.reasoner = reasoner;
    }

    @Override
    public boolean isInterrupted() {
        return this.reasoner.isInterrupted();
    }

    @Override
    public void clearInterrupt() {
        this.reasoner.clearInterrupt();
    }

    public boolean interrupted() throws ElkInterruptedException {
        boolean result = false;
        if (Thread.interrupted()) {
            result = true;
        }
        if (this.isInterrupted()) {
            this.clearInterrupt();
            throw new ElkInterruptedException(this.getName() + " interrupted");
        }
        return result;
    }

    void initComputation() {
        this.workerNo = this.reasoner.getNumberOfWorkers();
        this.progressMonitor = this.reasoner.getProgressMonitor();
    }
}

