/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rulesystem;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Context;
import org.semanticweb.elk.reasoner.saturation.rulesystem.IllegalInferenceMethodException;
import org.semanticweb.elk.reasoner.saturation.rulesystem.InferenceRule;
import org.semanticweb.elk.reasoner.saturation.rulesystem.InferenceSystem;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Queueable;
import org.semanticweb.elk.reasoner.saturation.rulesystem.RuleApplicationFactory;

public class InferenceSystemInvocationManager {
    protected static final Logger LOGGER_ = Logger.getLogger(InferenceSystemInvocationManager.class);
    protected static final String nameRuleMethod = "apply";
    protected static final Class<?>[] parameterTypesRuleMethod = new Class[]{Queueable.class, Context.class, RuleApplicationFactory.Engine.class};
    protected static final String nameInitMethod = "init";
    protected static final Class<?>[] parameterTypesInitMethod = new Class[]{Context.class, RuleApplicationFactory.Engine.class};
    protected static final String nameStoreMethod = "storeInContext";
    protected static final Class<?>[] parameterTypesStoreMethod = new Class[]{Context.class, RuleApplicationFactory.Engine.class};
    protected ConcurrentHashMap<Class<?>, InferenceMethods> methodsForQueueable = new ConcurrentHashMap(10, 0.5f, 4);
    protected InitMethodList initMethods;

    public void addInferenceSystem(InferenceSystem<?> inferenceSystem) throws IllegalInferenceMethodException, NoSuchMethodException {
        for (InferenceRule<?> inferenceRule : inferenceSystem.getInferenceRules()) {
            this.addInferenceRule(inferenceRule);
        }
    }

    protected void addInferenceRule(InferenceRule<?> inferenceRule) throws IllegalInferenceMethodException, NoSuchMethodException {
        Method[] methods;
        Class<?> ruleClass = inferenceRule.getClass();
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("Registering inference rule: " + ruleClass.toString()));
        }
        for (Method method : methods = ruleClass.getMethods()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (nameRuleMethod.equals(method.getName())) {
                this.registerRuleMethod(inferenceRule, method, paramTypes[0]);
            }
            if (!nameInitMethod.equals(method.getName())) continue;
            this.registerInitMethod(inferenceRule, method);
        }
    }

    protected void registerRuleMethod(InferenceRule<?> inferenceRule, Method ruleMethod, Class<?> queueableClass) throws IllegalInferenceMethodException, NoSuchMethodException {
        InferenceSystemInvocationManager.checkMethodSignature(ruleMethod, nameRuleMethod, parameterTypesRuleMethod);
        if (!this.methodsForQueueable.containsKey(queueableClass)) {
            this.initializeMethodsForClass(queueableClass);
        }
        this.registerRuleMethodForClass(inferenceRule, ruleMethod, queueableClass);
    }

    protected void registerInitMethod(InferenceRule<?> inferenceRule, Method initMethod) throws IllegalInferenceMethodException {
        InferenceSystemInvocationManager.checkMethodSignature(initMethod, nameInitMethod, parameterTypesInitMethod);
        this.addInitMethod(inferenceRule, initMethod);
    }

    protected static void checkMethodSignature(Method method, String methodName, Class<?>[] parameterTypes) throws IllegalInferenceMethodException {
        if (!methodName.equals(method.getName())) {
            throw new IllegalInferenceMethodException(method, "Method must be called '" + methodName + "'.");
        }
        Class<?>[] methodParamTypes = method.getParameterTypes();
        if (methodParamTypes.length != parameterTypes.length) {
            throw new IllegalInferenceMethodException(method, "Method must accept the following parameters: " + Arrays.deepToString(parameterTypes));
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].isAssignableFrom(methodParamTypes[i])) continue;
            throw new IllegalInferenceMethodException(method, "Method must accept the following parameters: " + Arrays.deepToString(parameterTypes));
        }
    }

    protected void initializeMethodsForClass(Class<?> clazz) throws NoSuchMethodException, IllegalInferenceMethodException {
        this.methodsForQueueable.put(clazz, this.getInitialMethodsForClass(clazz));
    }

    protected InferenceMethods getInitialMethodsForClass(Class<?> clazz) throws NoSuchMethodException, IllegalInferenceMethodException {
        InferenceMethods result = this.methodsForQueueable.containsKey(clazz) ? this.methodsForQueueable.get(clazz) : new InferenceMethods();
        try {
            result.storeMethod = clazz.getMethod(nameStoreMethod, parameterTypesStoreMethod);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("The queueable item " + clazz.getName() + " does not declare a method '" + nameStoreMethod + "' with parameters " + Arrays.deepToString(parameterTypesStoreMethod) + " as needed for storing it in a context.");
        }
        for (Class keyclass : this.methodsForQueueable.keySet()) {
            if (keyclass.equals(clazz) || !keyclass.isAssignableFrom(clazz)) continue;
            InferenceMethods keymethods = this.methodsForQueueable.get(keyclass);
            RuleMethodList keyrules = keymethods.ruleMethods;
            while (keyrules != null) {
                result.ruleMethods = this.addRuleMethod(keyrules.firstInferenceRule, keyrules.firstMethod, result.ruleMethods);
                keyrules = keyrules.rest;
            }
        }
        return result;
    }

    protected void registerRuleMethodForClass(InferenceRule<?> inferenceRule, Method ruleMethod, Class<?> clazz) {
        for (Class keyclass : this.methodsForQueueable.keySet()) {
            if (!clazz.isAssignableFrom(keyclass)) continue;
            InferenceMethods inferenceMethods = this.methodsForQueueable.get(keyclass);
            inferenceMethods.ruleMethods = this.addRuleMethod(inferenceRule, ruleMethod, inferenceMethods.ruleMethods);
        }
    }

    protected RuleMethodList addRuleMethod(InferenceRule<?> inferenceRule, Method ruleMethod, RuleMethodList ruleMethodList) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("Registering rule method " + ruleMethod.toString()));
        }
        return new RuleMethodList(inferenceRule, ruleMethod, ruleMethodList);
    }

    protected void addInitMethod(InferenceRule<?> inferenceRule, Method initMethod) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("Registering init method " + initMethod.toString()));
        }
        this.initMethods = new InitMethodList(inferenceRule, initMethod, this.initMethods);
    }

    protected synchronized void lateInitializeMethodsForClass(Class<?> clazz) {
        if (this.methodsForQueueable.containsKey(clazz)) {
            return;
        }
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("Late initialization of methods for class: " + clazz.toString()));
        }
        try {
            this.methodsForQueueable.put(clazz, this.getInitialMethodsForClass(clazz));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalInferenceMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void initContext(Context context, RuleApplicationFactory.Engine engine) throws IllegalArgumentException {
        if (this.initMethods == null) {
            throw new RuntimeException("Incomplete inference system: no initialization rules have been provided; nothing will ever be derived.");
        }
        try {
            this.initMethods.invoke(context, engine);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void processItemInContext(Queueable<?> queueable, Context context, RuleApplicationFactory.Engine engine) throws IllegalArgumentException {
        Class<?> clazz = queueable.getClass();
        InferenceMethods inferenceMethods = this.methodsForQueueable.get(clazz);
        if (inferenceMethods == null) {
            this.lateInitializeMethodsForClass(clazz);
            inferenceMethods = this.methodsForQueueable.get(clazz);
            assert (inferenceMethods != null);
        }
        try {
            if (Boolean.TRUE.equals(inferenceMethods.storeMethod.invoke(queueable, context, engine))) {
                if (inferenceMethods.ruleMethods != null) {
                    inferenceMethods.ruleMethods.invoke(queueable, context, engine);
                }
                this.applyAdditionalMethodsToItem(queueable, context, engine);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void applyAdditionalMethodsToItem(Queueable<?> queueable, Context context, RuleApplicationFactory.Engine engine) {
    }

    protected class InferenceMethods {
        Method storeMethod;
        RuleMethodList ruleMethods;

        protected InferenceMethods() {
        }
    }

    protected class InitMethodList {
        Method firstMethod;
        InferenceRule<?> firstInferenceRule;
        InitMethodList rest;

        public InitMethodList(InferenceRule<?> firstInferenceRule, Method firstMethod, InitMethodList rest) {
            this.firstInferenceRule = firstInferenceRule;
            this.firstMethod = firstMethod;
            this.rest = rest;
        }

        public void invoke(Context context, RuleApplicationFactory.Engine engine) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.firstMethod.invoke(this.firstInferenceRule, context, engine);
            if (this.rest != null) {
                this.rest.invoke(context, engine);
            }
        }
    }

    protected class RuleMethodList {
        Method firstMethod;
        InferenceRule<?> firstInferenceRule;
        RuleMethodList rest;

        public RuleMethodList(InferenceRule<?> firstInferenceRule, Method firstMethod, RuleMethodList rest) {
            this.firstInferenceRule = firstInferenceRule;
            this.firstMethod = firstMethod;
            this.rest = rest;
        }

        public void invoke(Queueable<?> argument, Context context, RuleApplicationFactory.Engine engine) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.firstMethod.invoke(this.firstInferenceRule, argument, context, engine);
            if (this.rest != null) {
                this.rest.invoke(argument, context, engine);
            }
        }
    }
}

