/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.classes;

import java.util.Collection;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.classes.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.classes.ContextElClassSaturation;
import org.semanticweb.elk.reasoner.saturation.classes.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.classes.RuleWithBackwardLinks;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Context;
import org.semanticweb.elk.reasoner.saturation.rulesystem.InferenceRule;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Queueable;
import org.semanticweb.elk.reasoner.saturation.rulesystem.RuleApplicationFactory;
import org.semanticweb.elk.util.collections.LazySetIntersection;
import org.semanticweb.elk.util.collections.Multimap;

public class RuleRoleComposition<C extends ContextElClassSaturation>
extends RuleWithBackwardLinks<C>
implements InferenceRule<C> {
    public void apply(BackwardLink<C> argument, C context, RuleApplicationFactory.Engine engine) {
        IndexedPropertyChain linkRelation = argument.getRelation();
        C target = argument.getTarget();
        if (((ContextElClassSaturation)context).composeBackwardLinks && linkRelation.getSaturated().getCompositionsByLeftSubProperty() != null) {
            engine.enqueue((Context)target, (Queueable<?>)new ForwardLink<C>(linkRelation, context));
        }
        Multimap<IndexedPropertyChain, IndexedPropertyChain> comps = linkRelation.getSaturated().getCompositionsByRightSubProperty();
        Multimap<IndexedPropertyChain, ContextElClassSaturation> forwLinks = ((ContextElClassSaturation)context).forwardLinksByObjectProperty;
        if (comps != null && forwLinks != null) {
            for (IndexedPropertyChain forwardRelation : new LazySetIntersection<IndexedPropertyChain>(comps.keySet(), forwLinks.keySet())) {
                Collection<IndexedPropertyChain> compositions = comps.get(forwardRelation);
                Collection<ContextElClassSaturation> forwardTargets = forwLinks.get(forwardRelation);
                for (IndexedPropertyChain composition : compositions) {
                    for (ContextElClassSaturation forwardTarget : forwardTargets) {
                        engine.enqueue(forwardTarget, new BackwardLink<C>(composition, target));
                    }
                }
            }
        }
    }

    public void apply(ForwardLink<C> argument, C context, RuleApplicationFactory.Engine engine) {
        this.initializeCompositionOfBackwardLinks(context, engine);
        IndexedPropertyChain linkRelation = argument.getRelation();
        C target = argument.getTarget();
        Multimap<IndexedPropertyChain, IndexedPropertyChain> comps = linkRelation.getSaturated().getCompositionsByLeftSubProperty();
        Multimap<IndexedPropertyChain, ContextElClassSaturation> backLinks = ((ContextElClassSaturation)context).backwardLinksByObjectProperty;
        if (backLinks != null) {
            for (IndexedPropertyChain backwardRelation : new LazySetIntersection<IndexedPropertyChain>(comps.keySet(), backLinks.keySet())) {
                Collection<IndexedPropertyChain> compositions = comps.get(backwardRelation);
                Collection<ContextElClassSaturation> backwardTargets = backLinks.get(backwardRelation);
                for (IndexedPropertyChain composition : compositions) {
                    for (ContextElClassSaturation backwardTarget : backwardTargets) {
                        engine.enqueue((Context)target, (Queueable<?>)new BackwardLink<ContextElClassSaturation>(composition, backwardTarget));
                    }
                }
            }
        }
    }
}

