/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.classes;

import java.util.Collection;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.classes.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.classes.ContextElClassSaturation;
import org.semanticweb.elk.reasoner.saturation.classes.InferenceRuleSCE;
import org.semanticweb.elk.reasoner.saturation.classes.NegativeSuperClassExpression;
import org.semanticweb.elk.reasoner.saturation.classes.RuleWithBackwardLinks;
import org.semanticweb.elk.reasoner.saturation.classes.SuperClassExpression;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Context;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Queueable;
import org.semanticweb.elk.reasoner.saturation.rulesystem.RuleApplicationFactory;
import org.semanticweb.elk.util.collections.LazySetIntersection;
import org.semanticweb.elk.util.collections.Multimap;

public class RuleExistentialPlus<C extends ContextElClassSaturation>
extends RuleWithBackwardLinks<C>
implements InferenceRuleSCE<C> {
    public void apply(BackwardLink<C> argument, C context, RuleApplicationFactory.Engine engine) {
        IndexedPropertyChain linkRelation = argument.getRelation();
        C target = argument.getTarget();
        if (!((ContextElClassSaturation)context).derivePropagations) {
            this.initializePropagations(context, engine);
            return;
        }
        Multimap<IndexedPropertyChain, Queueable<? extends ContextElClassSaturation>> props = ((ContextElClassSaturation)context).getPropagationsByObjectProperty();
        if (props == null) {
            return;
        }
        for (IndexedPropertyChain propRelation : new LazySetIntersection<IndexedPropertyChain>(linkRelation.getSaturated().getSuperProperties(), props.keySet())) {
            for (Queueable<? extends ContextElClassSaturation> carry : props.get(propRelation)) {
                engine.enqueue((Context)target, carry);
            }
        }
    }

    @Override
    public void applySCE(SuperClassExpression<C> argument, C context, RuleApplicationFactory.Engine engine) {
        Collection<IndexedObjectSomeValuesFrom> exists = argument.getExpression().getNegExistentials();
        if (!((ContextElClassSaturation)context).derivePropagations || exists == null) {
            return;
        }
        for (IndexedObjectSomeValuesFrom e : exists) {
            this.addPropagation(e.getRelation(), new NegativeSuperClassExpression(e), context, engine);
        }
    }

    private void initializePropagations(C context, RuleApplicationFactory.Engine engine) {
        ((ContextElClassSaturation)context).setDerivePropagations(true);
        for (IndexedClassExpression ice : ((ContextElClassSaturation)context).superClassExpressions) {
            if (ice.getNegExistentials() == null) continue;
            for (IndexedObjectSomeValuesFrom e : ice.getNegExistentials()) {
                this.addPropagation(e.getRelation(), new NegativeSuperClassExpression(e), context, engine);
            }
        }
    }

    private void addPropagation(IndexedPropertyChain propRelation, Queueable<C> carry, C context, RuleApplicationFactory.Engine engine) {
        if (((ContextElClassSaturation)context).propagationsByObjectProperty == null) {
            ((ContextElClassSaturation)context).initPropagationsByProperty();
            this.initializeCompositionOfBackwardLinks(context, engine);
        }
        if (((ContextElClassSaturation)context).propagationsByObjectProperty.add(propRelation, carry)) {
            Multimap<IndexedPropertyChain, ContextElClassSaturation> backLinks = ((ContextElClassSaturation)context).getBackwardLinksByObjectProperty();
            if (backLinks == null) {
                return;
            }
            for (IndexedPropertyChain linkRelation : new LazySetIntersection<IndexedPropertyChain>(propRelation.getSaturated().getSubProperties(), backLinks.keySet())) {
                for (ContextElClassSaturation target : backLinks.get(linkRelation)) {
                    engine.enqueue(target, carry);
                }
            }
        }
    }
}

